<?php

namespace App\Http\Controllers\Api\TeacherDashboard;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\TeacherDashboard\Namazeg\ClassNamazegResource;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolGrade;
use App\Models\ManagerDashboard\TeacherSchedule;
use App\Models\ManagerDashboard\TeacherScheduleData;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use PHPOpenSourceSaver\JWTAuth\Facades\JWTAuth;
use Illuminate\Validation\Rules\Password;

class NamazegTeacherController extends Controller
{
    /* to uses the class methods
        -you should be authenticated
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:teacher-dashboard-namazeg']);
    }

    public function get_classes(School $school, ClassName $className)
    {
        $user = JWTAuth::parseToken()->authenticate();

        $className_classes_ids = $school->classes()->where("school_id", $school->id)
            ->where('class_name_id', $className->id)->pluck('id')->toArray();

        $classes = TeacherScheduleData::where("school_employee_id", $user->id)
            ->whereHas("teacher_schedual", function ($q) use ($className_classes_ids, $school) {
                $q->whereIn("school_class_id", $className_classes_ids)
                    ->where('school_id', $school->id);
            })->get();
        $resource_data = ClassNamazegResource::collection($classes);
        return response()->json($resource_data);
    }

    public function get_schedual_details(TeacherScheduleData $schedualData)
    {

        return response()->json(
            [
                'current_school_year' => $schedualData->teacher_schedual?->school->current_school_year,
                'current_semester' => Helper::getCurrentSchoolSemester()?->name,
                'class_number' => $schedualData->teacher_schedual->class->class_number,
                'subject' => $schedualData->subject->name,
                'teacher_name' => $schedualData->employee->name,
                'students'=> $schedualData->teacher_schedual->class?->Students->pluck('name')->toArray()   
            ]
        );
    }
}
