<?php

namespace App\Http\Controllers\Api\School;

use App\Http\Controllers\Controller;
use App\Models\AdminDashboard\School\ClassName;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;
use App\Http\Requests\School\SchoolRegistrRequest;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolReference;
use App\Models\AdminDashboard\School\SchoolFacilitie;
use App\Helpers\Helper;
use App\Helpers\HelperNotification;
use App\Http\Resources\School\SchoolEmployeeResource;
use App\Http\Resources\School\SchoolFacilitieResource;
use App\Http\Resources\School\SchoolReferenceResource;
use App\Http\Resources\School\SchoolResource;
use App\Models\AdminDashboard\School\Student;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;

use App\Imports\StudentsImport;
use App\Imports\TeachersImport;
use App\Jobs\SaveSchedulesJob;
use App\Jobs\SendEmailJob;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\User;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;

class SchoolRegistrationController extends Controller
{


    /* to uses the class methods
        -you should be authenticated
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api']);
    }

    public function register(SchoolRegistrRequest $request ,$step){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }

        switch($step) {

            /** school type must be shared or not shared value */
            case $step == 1:

                $userSchools = School::where('user_id', $user->id)->get();
                if (count($userSchools) > 0 && count($userSchools) == 2) {
                    return response()->json(['message' => trans('api.you can not add new school')], 401);
                }

                if ($request->type == 'shared') {
                    /**school 1 */
                    $school1 = School::create(['user_id' => $user->id, 'current_school_year' => Helper::getSchoolYear(), 'reg_step1' => 'completed']);
                    $school1Facilities = SchoolFacilitie::create(['school_id' => $school1->id]);
                    $school1Reference = SchoolReference::create(['school_id' => $school1->id]);

                    /* update adminstrative data*/
                    $adminstrative1 = SchoolEmployee::where('user_id', $user->id)->first();
                    $adminstrative1->school_id = $school1->id;
                    $adminstrative1->current_school_year = $school1->current_school_year;
                    $adminstrative1->save();

                    /**school 2 */
                    $school2 = School::create(['user_id' => $user->id, 'current_school_year' => Helper::getSchoolYear(), 'reg_step1' => 'completed']);
                    $school2Facilities = SchoolFacilitie::create(['school_id' => $school2->id]);
                    $school2Reference = SchoolReference::create(['school_id' => $school2->id]);

                    if ($adminstrative1) {
                        $adminstrative2 = new SchoolEmployee();
                        $adminstrative2->fill($adminstrative1->toArray());
                        $adminstrative2->id = null;
                        $adminstrative2->school_id = $school2->id;
                        $adminstrative2->save();
                    }

                    return response()->json(['schoolIds' => [$school1->id, $school2->id], 'message' => trans('api.school initial data stored successfully')]);

                } else {
                    $school = School::create(['user_id' => $user->id, 'current_school_year' => Helper::getSchoolYear(), 'reg_step1' => 'completed']);
                    $schoolFacilities = SchoolFacilitie::create(['school_id' => $school->id]);
                    $schoolReference = SchoolReference::create(['school_id' => $school->id]);

                    /* update adminstrative data*/
                    $adminstrative1 = SchoolEmployee::where('user_id', $user->id)->first();
                    $adminstrative1->school_id = $school->id;
                    $adminstrative1->current_school_year = $school->current_school_year;
                    $adminstrative1->save();
                    return response()->json(['schoolIds' => [$school->id], 'message' => trans('api.school initial data stored successfully')]);
                }
                break;

            /** school main informations */
            case $step == 2:
                $school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();
                $school->update($request->except('school_id'));
                $school = new SchoolResource($school);
                return response()->json(['school' => $school, 'message' => trans('api.school data updated successfully')]);
                break;

            /** school facilitie main informations */
            case $step == 3:
                $school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();

                $schoolFacilitie = SchoolFacilitie::where('school_id', $school->id)->firstOrFail();

                $schoolFacilitie->update($request->except('school_id'));


                /**  if ther is another school */
                $school2 = School::where('user_id', $user->id)->skip(1)->take(1)->first();
                if ($school2) {
                    $schoolFacilitie = SchoolFacilitie::where('school_id', $school2->id)->firstOrFail();
                    $schoolFacilitie->update($request->except('school_id'));
                }
                $school->update(['reg_step3' => 'completed']);

                $schoolFacilitie = new SchoolFacilitieResource($schoolFacilitie);
                return response()->json(['schoolFacilitie' => $schoolFacilitie, 'message' => trans('api.school facilities updated successfully')]);
                break;

            /** importing students data */
            case $step == 4:
                $school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();

                /** get ids of old data */
                $classNameIds = ClassName::where('school_id', $school->id)->pluck('id')->toArray();
                $schoolClassIds = SchoolClass::where('school_id', $school->id)->pluck('id')->toArray();
                $studentIds = Student::where('school_id', $school->id)->pluck('id')->toArray();

                $file = $request->file('file');
                $skipRows = [0, 1, 2, 6, 5, 9, 10, 13, 14, 15, 16, 17, 18]; // Define the rows to skip
                $import =  Excel::import(new StudentsImport($file, $skipRows, $request->school_id), $file);

                $students = Student::where('school_id', $school->id)->pluck('id')->toArray();

                if (count($students) <= count($studentIds)) {
                    $school->update(['reg_step4' => 'incompleted']);
                    return response()->json(['error' => trans('api.students data not imported check file is a valid file')], 404);
                }

                $school->update(['reg_step4' => 'completed']);


                /* mark classes and class name data_imported flag to 1*/
                $classNames=ClassName::where('school_id',$school->id)->where('data_imported',0)->get();
                foreach($classNames as $className){
                    $className ->update(['data_imported' => 1]);
                }

                $SchoolClasses=SchoolClass::where('school_id',$school->id)->where('data_imported',0)->get();
                foreach($SchoolClasses as $SchoolClass){
                    $SchoolClass ->update(['data_imported' => 1]);
                }

                /** delete school old records before upload new file */
                ClassName::whereIn('id', $classNameIds)->forceDelete();
                SchoolClass::whereIn('id', $schoolClassIds)->forceDelete();
                Student::whereIn('id', $studentIds)->forceDelete();

                return response()->json(['message' => trans('api.students data imported successfully')]);
                break;

            /** importing teachers data */
            case $step == 5:
                $school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();

                /** get old ids */
                $employeesIds = SchoolEmployee::where('type', 'teacher')->where('school_id', $school->id)->pluck('id')->toArray();
                $userIds = SchoolEmployee::where('type', 'teacher')->where('school_id', $school->id)->pluck('user_id')->toArray();

                /*upload file after deleting old records if found */
                $file = $request->file('file');
                $skipRows = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13]; // Define the rows to skip
                Excel::import(new TeachersImport($file, $skipRows, $request->school_id), $file);

                $teachers = SchoolEmployee::where('type', 'teacher')->where('school_id', $school->id)->pluck('id')->toArray();
                if (count($teachers) <= count($employeesIds)) {
                    $school->update(['reg_step5' => 'incompleted']);
                    return response()->json(['error' => trans('api.teachers data not imported check file is a valid file')], 404);
                }

                $school->update(['reg_step5' => 'completed']);

                /** delete school old records before upload new file */
                SchoolEmployee::whereIn('id', $employeesIds)->forceDelete();
                User::whereIn('id', $userIds)->forceDelete();

                // Get all registered users
                $school_employees = SchoolEmployee::where('type', 'teacher')->where('school_id', $school->id)->get();

                /** send email with email caradentials to all employees */
                foreach ($school_employees as $school_employee) {
                    /** create users accounts */
                    $temp_password = 'teacher' . mt_rand(100000, 999999);
                    $this->createUserAccounts($school_employee->id, $school_employee->name, $school_employee->email, $school_employee->phone, $temp_password);
                    //SendEmailJob::dispatch($school_employee); // Dispatch the job for each school employee
                }

                return response()->json(['message' => trans('api.teachers data imported successfully')]);
                break;

            case $step == 6:
                $school = School::where('user_id', $user->id)->where('id', $request->school_id)->firstOrFail();
                $employeeCounts = $this->getEmployeeCounts($request->school_id);
                // Validate current_work_id
                if ($this->isEmployeeTypeLimitReached($request->current_work_id, $employeeCounts)) {
                    return response()->json(['errors' => ['employee-_limit_reached'=>$this->getErrorMessage($request->current_work_id)],
                        'message'=>trans('api.employee_limit_reached')], 400);
                }

                $data = $request->all();
                $data['type'] = 'adminstrative';

                if(in_array($request->current_work_id,[6,7,8])){
                    $data['have_account'] = 'yes';
                }

                $adminstrative = SchoolEmployee::create($data);

                /** create users accounts */
                if($request->have_account == 'yes'){
                    $temp_password = 'adminstrative' . mt_rand(100000, 999999);
                    $this->createUserAccounts($adminstrative->id, $adminstrative->name, $adminstrative->email, $adminstrative->phone, $temp_password);
                }

                $adminstrative = new SchoolEmployeeResource($adminstrative);
                $school->update(['reg_step6'=>'completed','registration_complete'=>'yes']);

                return response()->json(['adminstrative'=>$adminstrative,'message' => trans('api.adminstrative record stored successfully')]);
                break;

            /** school references main informations */
            case $step == 7:
                $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
                $schoolReference = SchoolReference::where('school_id',$school->id)->firstOrFail();
                $schoolReference->update($request->all());
                $schoolReference= new SchoolReferenceResource($schoolReference);

                // /**save teacher schedules*/
                // /**save  super vision schedules*/
                /* save manager plans*/
                // SaveSchedulesJob::dispatch($school->id);
                // $output = shell_exec("ps aux | grep 'php artisan queue:work' | grep -v grep ");
                // if (!isset($output)) {
                //     Artisan::call('queue:work', ['--stop-when-empty' => true]);
                // }

                Helper::saveTeacherSchedules($school->id);
                Helper::saveSupervisionSchedules($school->id);
                Helper::managerPLans($school->id);


                /** store SchoolManager Assignment*/
                Helper::storeSchoolManagerAssignment($school->id);


                /* Notifications settings*/
                Helper::store_default_notification_settings($school->id);

                $helperNotification = new HelperNotification($user);
                $helperNotification ->create_namazegSchoolCommitment_notifications();

                $school->update(['reg_step7'=>'completed','registration_complete'=>'yes']);

                return response()->json(['schoolReference'=>$schoolReference,'message' => trans('api.school reference updated successfully')]);
                break;
        }
    }

    /** method check the school registration steps
     *  to move to incompleted stepd */
    public function checkSchoolRegSteps(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $regSteps=[
            'step1'=> $school->reg_step1,
            'step2'=> $school->reg_step2,
            'step3'=> $school->reg_step3,
            'step4'=> $school->reg_step4,
            'step5'=> $school->reg_step5,
            'step6'=> $school->reg_step6,
            'step7'=> $school->reg_step7,
        ];
        return response()->json(['regSteps'=>$regSteps,'message' => trans('api.school registration steps status')]);
    }

    public function createUserAccounts($empId,$name,$email,$phone,$temp_password){
        $user = new User();
        $user->name = $name ;
        $user->email = $email ;
        $user->phone = $phone ;
        $user->password = Hash::make($temp_password) ;
        $user->password_reseted = 'no' ;
        $user->status = 'active' ;
        $user->user_type = 'teacher' ;
        $user->verification_code = mt_rand(100000, 999999);
        $user->save();

        /** add user Id to school employee */
        $schoolEmployee = SchoolEmployee::find($empId);
        $schoolEmployee->user_id = $user->id;
        $schoolEmployee->have_account = 'yes';
        $schoolEmployee->save();
    }


    private function getEmployeeCounts($schoolId){
        // Use one query to get all counts
        return [
            'school_manager' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 1)->count(),
            'educational_administrative' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 6)->count(),
            'students_administrative' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 7)->count(),
            'school_administrative' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 8)->count(),
            'administrative_assistant' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 9)->count(),
            'health_mentor' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 10)->count(),
            'students_mentor' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 11)->count(),
            'learning_resource_creator' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 12)->count(),
            'laboratory_preparator' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 13)->count(),
            'info_recorder_' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 14)->count(),
            'activity_creator' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 15)->count(),
            'school_guard' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 16)->count(),
            'service_worker' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 17)->count(),
            'service_employee' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 18)->count(),
            'school_manager_secretary' => SchoolEmployee::where('school_id', $schoolId)->where('current_work_id', 19)->count(),
        ];
    }

    private function isEmployeeTypeLimitReached($currentWorkId, $employeeCounts)
    {
        // Add conditions for specific work IDs and their limits
        return ($currentWorkId == 1 && $employeeCounts['school_manager']  >= 1) ||
            ($currentWorkId == 6 && $employeeCounts['educational_administrative']  >=1) ||
            ($currentWorkId == 7 && $employeeCounts['students_administrative']  >= 1) ||
            ($currentWorkId == 8 && $employeeCounts['school_administrative']  >= 1) ||
            ($currentWorkId == 9 && $employeeCounts['administrative_assistant'] >= 3)||
            ($currentWorkId == 10 && $employeeCounts['health_mentor'] >= 1)||
            ($currentWorkId == 11 && $employeeCounts['students_mentor'] >= 3)||
            ($currentWorkId == 12 && $employeeCounts['learning_resource_creator'] >= 1)||
            ($currentWorkId == 13 && $employeeCounts['laboratory_preparator'] >= 2)||
            ($currentWorkId == 14 && $employeeCounts['info_recorder_'] >= 2)||
            ($currentWorkId == 15 && $employeeCounts['activity_creator'] >= 1)||
            ($currentWorkId == 16 && $employeeCounts['school_guard'] >= 1)||
            ($currentWorkId == 17 && $employeeCounts['service_worker'] >= 2)||
            ($currentWorkId == 18 && $employeeCounts['service_employee'] >= 1)||
            ($currentWorkId == 19 && $employeeCounts['school_manager_secretary'] >= 1);
    }

    private function getErrorMessage($currentWorkId)
    {
        // Return error messages based on work ID
        switch ($currentWorkId) {
            case 1:
                return trans('api.school_manager_added_before');
            case 6:
                return trans('api.educational_administrative_added_before');
            case 7:
                return trans('api.students_administrative_added_before');
            case 8:
                return trans('api.school_administrative_added_before');
            case 9:
                return trans('api.administrative_assistant_added_before');
            case 10:
                return trans('api.health_mentor_added_before');
            case 11:
                return trans('api.students_mentor_added_before');
            case 12:
                return trans('api.learning_resource_creator_added_before');
            case 13:
                return trans('api.laboratory_preparator_added_before');
            case 14:
                return trans('api.info_recorder_added_before');
            case 15:
                return trans('api.activity_creator_added_before');
            case 16:
                return trans('api.school_guard_added_before');
            case 17:
                return trans('api.service_worker_added_before');
            case 18:
                return trans('api.service_employee_added_before');
            case 19:
                return trans('api.school_manager_secretary_added_before');

            default:
                return trans('api.invalid_work_id');
        }
    }
}
