<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Violations;

use App\Helpers\GradeViolationsHelper;
use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Violations\ManagerVioaltionStoreRequest;
use App\Http\Requests\ManagerDashboard\Violations\ManagerVioaltionStoreTwoRequest;
use App\Http\Requests\ManagerDashboard\Violations\UpdateViolationDegreeRequest;
use App\Http\Resources\ManagerDashboard\ViolationStudents\StudentDegreesResource;
use App\Http\Resources\ManagerDashboard\ViolationStudents\ViolationStudentDetailsResource;
use App\Http\Resources\ManagerDashboard\ViolationStudents\ViolationStudentsResource;
use App\Http\Resources\Violation\ViolationResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Student;
use App\Models\BasicRelativePunishment;
use App\Models\GradeViolation;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegProceduresFormOption;
use App\Models\ManagerDashboard\Namazeg\Violations\StudentViolationDegrees;
use App\Models\ManagerDashboard\Violations\ViolationStudent;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\ManagerDashboard\Violations\ViolationStudentTitle;
use App\Models\Namazeg;
use App\Models\RelatedViolations;
use App\Models\Violation;
use App\Models\ViolationPunishment;
use App\Models\ViolationTitle;
use App\Models\ViolationType;
use App\Providers\NamozegFactoryProvider;
use Illuminate\Http\Request;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use App\Traits\SmsTrait;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Support\Facades\DB;
use Intervention\Image\Colors\Rgb\Channels\Red;
use Tymon\JWTAuth\Facades\JWTAuth;

class ManagerViolationController extends Controller
{
    use LogsActivity, NamazegTrait, SmsTrait;

    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:manager-violations']);
    }

    public function get_category_by_school(School $school, Request $request)
    {
        $school_grade_id = $school->school_grade_id;
        $data = Violation::with('violation_grades')->where('school_grade_id', $school_grade_id)->get()
            ->map(function ($violation) {
                return [
                    'violation_category_id' => $violation->id,
                    'violation_category_name' => $violation->name,
                    'violation_grades' => $violation->violation_grades->select('id', 'name'),
                ];
            });
        return response()->json($data);
    }


    public function getAll(Request $request, $school_id)
    {
        ViolationStudent::where('school_id', $school_id)->where('published', 0)->delete();
        $data = ViolationStudent::with('student')
            ->whereHas('student')
            ->where('school_id', $school_id)
            ->select('student_id', DB::raw('COUNT(*) as n_violations'), DB::raw('Min(created_at) as latest_created_at'))
            ->groupBy('student_id');


        $queryParams = $request->query();

        if (!empty($queryParams)) {
            if (isset($queryParams['class_number'])) {
                $data->whereHas('student.schoolClass', function ($query) use ($queryParams) {
                    $query->where('class_number', $queryParams['class_number']);
                });
            }
            if (isset($queryParams['student_name'])) {
                $name = $queryParams['student_name'];
                $data->whereHas('student', function ($query) use ($name) {
                    $query->where('name', 'like', "%$name%");
                });
            }
            if (isset($queryParams['class_id'])) {
                $classId = $queryParams['class_id'];
                $data->whereHas('student.schoolClass', function ($query) use ($classId) {
                    $query->where('class_name_id', 'like', "%$classId%");
                });
            }
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = ViolationStudentsResource::collection($data->paginate($perPage));
        return response()->json([
            'violation_students' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    public static function details(Student $student, Request $request)
    {
        $class = $student->schoolClass;
        $n_violation = 0;
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;

        $violation_categories = Violation::with('violation_grades')->where('school_grade_id', $student->schoolClass->className->school_grade_id)->get()->map(function ($violation_category) use ($student, &$n_violation, $perPage) {
            $violation_category->violation_grades->map(function ($violation_grade) use ($student, $violation_category, &$n_violation, $perPage) {
                $violations = ViolationStudent::with('type')->where('violation_grade_id', $violation_grade->id)
                    ->where('violation_category_id', $violation_category->id)
                    ->where('student_id', $student->id)->paginate($perPage);

                $n_violation += $violations->total();
                $violation_grade->student_violations = $violations;
            });
            return $violation_category;
        });
        $data_resource = ViolationStudentDetailsResource::collection($violation_categories);

        return response()->json([
            'student_name' => $student->name,
            'class_name' => $class->className->name,
            'class_number' => $class->class_number,
            'n_violation' => $n_violation,
            'violation' => $data_resource
        ]);
    }

    // step 1
    public function store(ManagerVioaltionStoreRequest $request)
    {
        $student = Student::findOrFail($request->student_id);
        $school = School::findOrFail($student->school_id);
        $data = $request->all();
        $data['school_id'] = $school->id;
        if ($data['date_type'] === 'hijri') {
            $data['date'] = Helper::getCoptic($data['date']);
        }
        unset($data['date_type']);
        $namozeg = Namazeg::where('form_number', '108')->first();
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school->id
        );

        $data['namazeg_version_id'] = $namozeg_version->id;
        $violation = ViolationStudent::create($data);
        $types = ViolationType::where('violation_grade_id', $request->violation_grade_id)->select('id', 'name')->get();
        $user =  JWTAuth::parseToken()->authenticate();
        $message_text = "تم تسجيل مخالفة سلوكية للطالب " . $student->name . " نرجو المتابعه والاهتمام.";
        static::sendSMSNotification($student->phone, $message_text, $user->manager_id);


        return response()->json(['violation' => $violation, 'types' => $types, 'message' => trans('api.record stored successflly')]);
    }

    // step 2
    public function store_step_two(ManagerVioaltionStoreTwoRequest $request, ViolationStudent $violation_student)
    {

        // check_old_violation_with_same_type
        $check_old_violation = ViolationStudent::where('student_id', $violation_student->student_id)
            ->where(function ($query) use ($request) {
                if ($request->violation_type_id) {
                    $query->where('violation_type_id', $request->violation_type_id);
                } else {
                    $query->where('other_type', $request->other_type);
                }
            })->first();
        if ($check_old_violation) {
            return response()->json([
                'error' => 'نوع المخالفة موجود بالفعل لهذا الطالب',
            ], 422);
        }
        $violation_student->update($request->all());
        $violation_title = ViolationTitle::where('violation_grade_id', $violation_student->violation_grade_id)
            ->orderBy('name', 'asc')->firstOrFail();




        $first_violation_title_data = GradeViolationsHelper::get_violation_namazeg_nessaccery_only($violation_title->id);

        return response()->json(['violation_title_id' => $violation_title->id, 'first_vioaltion_title_data' => $first_violation_title_data, 'message' => trans('api.record stored successflly')]);
    }

    public static function violation_title_details(ViolationStudent $student_violation, ViolationTitle $violation_title)
    {
        //for the given violation student and title
        $punishments = ViolationStudentTitle::with('punishments')
            ->where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $violation_title->id)
            ->first()?->punishments;
        $data = GradeViolationsHelper::get_violation_title_data($violation_title->id);
        $basicPunishments = collect($data['basic_punishments']);
        $relatedPunishments = ($data['related_punishments']);

        //basic punishments
        $processedBasicPunishments = $basicPunishments->map(function ($punishment) use ($punishments) {
            $basic_namazeg = (object) $punishment['basic_namazeg'];
            $basic_check = $punishments?->where('punishment_id', $basic_namazeg->id)->first();

            // Prepare basic namazeg

            $basic_namazeg_data = [
                'punishment_id' => $basic_namazeg->id,
                'name' => $basic_namazeg->name,
                'details' => $basic_namazeg->details,
                'status' => $basic_check?->status
            ];

            //related punishments
            $related_punishments = collect($punishment['relative_basic_namazeg']);
            $relative_basic_namazeg = $related_punishments->map(function ($related_punishment) use ($punishments) {
                return [
                    'punishment_id' => $related_punishment->id,
                    'name' => $related_punishment->name,
                    'details' => $related_punishment->details,
                    'status' => $punishments?->where('punishment_id', $related_punishment->id)->first()?->status
                ];
            });
            if ($basic_check) {
                return [
                    "basic_namazeg" => $basic_namazeg_data,
                    "relative_basic_namazeg" => $relative_basic_namazeg,
                ];
            }
            return null;
        })->filter();

        //related punishments
        $processedRelatedPunishments = collect($relatedPunishments)->map(function ($relatedPunishmentCollection, $name) use ($punishments) {
            // Map over each punishment in the nested collection
            return [
                'name' => $name, // Use the key as the 'name'
                'punishments' => collect($relatedPunishmentCollection)->map(function ($related_punishment) use ($punishments) {
                    // Check for punishment status in the $punishments collection
                    $related_punishments_check = $punishments?->where('punishment_id', $related_punishment['id'])->first();
                    if ($related_punishments_check) {
                        return [
                            'punishment_id' => $related_punishment['id'],
                            'name' => $related_punishment['name'],
                            'status' => $related_punishments_check->status,
                        ];
                    }

                    return null; // Return null if no status is found
                })->filter()->values() // Filter out nulls and re-index
            ];
        })->values();

        $all_punshments = $processedBasicPunishments->concat($processedRelatedPunishments);
        $n_done = $all_punshments->where('status', 'done')->count();
        $n_all = $all_punshments->count();
        $percentage = ($n_all > 0) ? ($n_done / $n_all) * 100 : 0;
        $result = [
            'percentage' => $percentage,
            'punishments' => $all_punshments->values()
        ];

        return response()->json(['data' => $result]);
    }

    public function apply_violation_namazeg(Request $request, ViolationStudent $student_violation, ViolationTitle $violation_title)
    {
        $school_id = $student_violation->school_id;
        $other_violation_titles = ViolationTitle::where('violation_grade_id', $violation_title->violation_grade_id)
            ->where('id', '!=', $violation_title->id)->orderBy('name', 'asc')->get();

        $date = $request->date_type == "hijri" ? Helper::getCoptic($request->date) : $request->date;

        $violation_student_title = ViolationStudentTitle::updateOrcreate(
            [
                'violation_student_id' => $student_violation->id,
                'violation_title_id' => $violation_title->id,
            ],
            [
                'status' => 'started',
                'date' => $date
            ]
        );

        foreach ($other_violation_titles as $other_violation_title) {
            ViolationStudentTitle::updateOrcreate(
                [
                    'violation_student_id' => $student_violation->id,
                    'violation_title_id' => $other_violation_title->id,
                ],
                [
                    'date' => $date
                ]
            );
        }

        $realted_violation_punihsments = RelatedViolations::where('relation_violation_titles_id', $violation_title->id)->get();
        $realted_violation_punihsments_title_ids = $realted_violation_punihsments->pluck('violation_titles_id')->unique()->toArray();
        $realted_violation_punihsments_ids = $realted_violation_punihsments->whereIn('violation_punishment_id', $request->punishment_ids)->pluck('violation_punishment_id')->unique()->toArray();
        $required_punishments = ViolationPunishment::with('related_punishments')
            ->where('violation_title_id', $violation_title->id)
            ->whereIn('violation_punishment_id', $request->punishment_ids)->get();

        $realted_violation_punihsments_data = ViolationPunishment::with('related_punishments')
            ->whereIn('violation_title_id', $realted_violation_punihsments_title_ids)
            ->whereIn('violation_punishment_id', $realted_violation_punihsments_ids)->get();
        $all_punishments = $required_punishments->concat($realted_violation_punihsments_data);
        foreach ($all_punishments as $all_punishment) {
            if ($all_punishment->related_punishments->isNotEmpty()) {
                $all_punishment->related_punishments->map(function ($related) use ($violation_student_title, $school_id) {
                    $namozeg_version = $this->storeNamazegVersion(
                        $related->violation_punishment_id,
                        'internal',
                        $school_id
                    );
                    ViolationStudentPunishment::create([
                        'violation_student_title_id' => $violation_student_title->id,
                        'punishment_id' => $related->violation_punishment_id,
                        'namazeg_version_id' => $namozeg_version->id
                    ]);
                });
            }
            $basic_namozeg_version = $this->storeNamazegVersion(
                $all_punishment->violation_punishment_id,
                'internal',
                $school_id
            );
            ViolationStudentPunishment::updateOrCreate([
                'violation_student_title_id' => $violation_student_title->id,
                'punishment_id' => $all_punishment->violation_punishment_id,
            ], [
                'namazeg_version_id' => $basic_namozeg_version->id
            ]);
        }


        $namazeg_need_inputs = [141, 142, 143, 145, 146, 147, 149, 151, 157, 160, 161, 228, 132];
        $namazeg_need_inputs_ids = Namazeg::whereIn('form_number', $namazeg_need_inputs)->pluck('id')->toArray();
        ViolationStudentPunishment::whereNotIn('punishment_id', $namazeg_need_inputs_ids)
            ->where('violation_student_title_id', $violation_student_title->id)
            ->update(['status' => 'done']);

        NamozegFactoryProvider::update_status_violationStudentTitle($violation_student_title->id);

        $form_number = $student_violation->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('ViolationStudentPunishment', 'store', $student_violation->student->school_id, $form_number);
        return response()->json(['message' => trans('api.record stored successflly')]);
    }
    public function skip_violation_namazeg(Request $request, ViolationStudent $student_violation, ViolationTitle $violation_title)
    {

        $violation_student_title = ViolationStudentTitle::where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $violation_title->id)->first();
        ViolationStudentPunishment::where('violation_student_title_id', $violation_student_title->id)
            ->where('punishment_id', $request->punishment_id)->update(['status' => 'skipped']);

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    public function mark_violation_title_complete(ViolationStudent $student_violation, ViolationTitle $violation_title)
    {

        $violation_student_title = ViolationStudentTitle::where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $violation_title->id)->first();
        ViolationStudentPunishment::where('violation_student_title_id', $violation_student_title->id)
            ->update(['status' => 'done']);
        $violation_student_title->update(['status' => 'done']);
        $this->ManagerlogActivity('ViolationStudent', 'store', $student_violation->student->school_id, 108);

        return response()->json(['message' => trans('api.record updated successflly')]);
    }
    public function skip_reason(Request $request, ViolationStudent $student_violation, ViolationTitle $violation_title)
    {
        $request->validate([
            'reasons' => 'required|array',
            'reasons*' => 'string',
        ]);
        $violation_student_title = ViolationStudentTitle::where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $violation_title->id)->first();
        foreach ($request->reasons as $punishment_id => $reason) {
            $affected = ViolationStudentPunishment::where('violation_student_title_id', $violation_student_title->id)
                ->where('punishment_id', $punishment_id)
                ->update(['skip_reason' => $reason, 'status' => 'done']);
        }
        if ($affected == 0) {
            return response()->json([
                'error' => 'بيانات غير موجوده . خطأ'
            ], 404);
        }
        $violation_student_title->update(['status' => 'done']);

        return response()->json(['message' => "Reason updated successfully."]);
    }


    public function student_violation_title_details(ViolationStudent $student_violation, ViolationTitle $violation_title)
    {
        $violation_student_title = ViolationStudentTitle::with('punishments', 'title', 'ViolationStudent')->where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $violation_title->id)->first();
        $data = $violation_student_title->punishments->map(function ($punishment) {
            return [
                'id' => $punishment->namozeg->id,
                'form_number' => $punishment->namozeg->form_number,
                'serial_number' => $punishment->namozegVersion?->serial_number,
                'name' => $punishment->namozeg->name,
                'status' => $punishment->status,
                'reason' => $punishment->skip_reason,
            ];
        });
        // return $data;
        $violation_title_percentage = $data->where('status', 'done')->count() / $data->count() * 100;
        return response()->json([
            'violation_title_percentage' => $violation_title_percentage,
            'title' => $violation_student_title->title?->violation_name?->name,
            'grade' => $violation_student_title->ViolationStudent?->violationGrade?->name,
            'category' => $violation_student_title->ViolationStudent?->category?->name,
            'data' => $data
        ]);
    }

    public function get_next_namazeg(ViolationStudent $student_violation)
    {
        // if already open violations title and started without finishing
        $violation_student_title = $student_violation->violation_titles->where('status', 'started')->sortBy('id')->last();
        // if already open violation and done and want to open another one
        $violation_student_still_title = $student_violation->violation_titles->where('status', 'still')->sortBy('id')->last();

        if ($violation_student_title) {
            // Retrieve data with GradeViolationsHelper
            $basic_punishments = ViolationTitle::with('punishments.namzeg')
                ->where('id', $violation_student_title->title->id)
                ->get();
            $basic_punishments = $basic_punishments->flatMap(function ($violation_title) {
                return $violation_title->punishments->map(function ($punishment) {
                    // Get the namzeg for the current punishment
                    $data = collect();
                    $namzeg = $punishment->namzeg;

                    // Get related punishments (including their namzeg)
                    $related_punishments = $punishment->related_punishments->map(function ($related_punishment) {
                        return $related_punishment->namzeg;
                    });

                    $data = $data->concat([$namzeg]); // Use concat properly
                    $data = $data->concat($related_punishments); // Concatenate related punishments

                    return $data;
                });
            })->flatten(1)->unique()->values()->toArray();

            $related_punishments = RelatedViolations::with('punishments')
                ->where('relation_violation_titles_id', $violation_student_title->title->id)
                ->get()
                ->groupBy(function ($item) {
                    return $item->violation_titles_id . '|' . $item->custom_name;
                })
                ->map(function ($group, $key) {
                    // Split the key into relation_violation_titles_id and custom_name
                    [$real_violation_titles_id, $custom_name] = explode('|', $key);

                    $punishments = $group->map(function ($related_punishment) {
                        return [
                            'id' => $related_punishment->punishments->id,
                            'name' => $related_punishment->punishments->name,
                            'details' => $related_punishment->punishments->details,
                            'form_number' => $related_punishment->punishments->form_number,
                            'addition_related' => $related_punishment->addition_related,
                        ];
                    });
                    return [
                        'relation_violation_titles_id' => (int)$real_violation_titles_id,
                        'custom_name' => $custom_name,
                        'punishments' => $punishments->toArray(),
                    ];
                })
                ->values();
            $result =  [
                'violation_title_name' => $violation_student_title->title->violation_name->name,
                'violation_student_title_id' => $violation_student_title->id,
                'basic_punishments' => $basic_punishments,
                'related_punishments' => $related_punishments
            ];
        } elseif ($violation_student_still_title) {
            $violation_student_title = $violation_student_still_title;
            $violation_student_title = $student_violation->violation_titles->where('status', 'still')->sortBy('id')->first();

            $basic_punishments = ViolationTitle::with('punishments.namzeg')
                ->where('id', $violation_student_title->title->id)
                ->get();
            $basic_punishments = $basic_punishments->flatMap(function ($violation_title) {
                return $violation_title->punishments->map(function ($punishment) {
                    // Get the namzeg for the current punishment
                    $data = collect();
                    $namzeg = $punishment->namzeg;

                    // Get related punishments (including their namzeg)
                    $related_punishments = $punishment->related_punishments->map(function ($related_punishment) {
                        return $related_punishment->namzeg;
                    });

                    $data = $data->concat([$namzeg]); // Use concat properly
                    $data = $data->concat($related_punishments); // Concatenate related punishments

                    return $data;
                });
            })->flatten(1)->unique()->values()->toArray();

            $related_punishments = RelatedViolations::with('punishments')
                ->where('relation_violation_titles_id', $violation_student_title->title->id)
                ->get()
                ->groupBy(function ($item) {
                    return $item->violation_titles_id . '|' . $item->custom_name;
                })
                ->map(function ($group, $key) {
                    // Split the key into relation_violation_titles_id and custom_name
                    [$real_violation_titles_id, $custom_name] = explode('|', $key);

                    $punishments = $group->map(function ($related_punishment) {
                        return [
                            'id' => $related_punishment->punishments->id,
                            'name' => $related_punishment->punishments->name,
                            'details' => $related_punishment->punishments->details,
                            'form_number' => $related_punishment->punishments->form_number,
                            'addition_related' => $related_punishment->addition_related,
                        ];
                    });
                    return [
                        'relation_violation_titles_id' => (int)$real_violation_titles_id,
                        'custom_name' => $custom_name,
                        'punishments' => $punishments->toArray(),
                    ];
                })
                ->values();
            $result =  [
                'violation_title_name' => $violation_student_title->title->violation_name->name,
                'violation_student_title_id' => $violation_student_title->id,
                'basic_punishments' => $basic_punishments,
                'related_punishments' => $related_punishments
            ];
        } else {
            $violation_title = ViolationTitle::where('violation_grade_id', $student_violation->violation_grade_id)->orderBy('name', 'asc')->firstOrFail();
            $first_violation_title_data = GradeViolationsHelper::get_violation_namazeg_nessaccery_only($violation_title->id);

            // return ['ramzy'=>$first_violation_title_data];

            return  [
                'violation_title_name' => $violation_title->violation_name->name,
                'violation_title_id' => $violation_title->id,
                'basic_punishments' => $first_violation_title_data['basic_punishments'],
                'related_punishments' => []
            ];

            // $vioaltion_title = ViolationTitle::where('violation_grade_id', $student_violation->violation_grade_id)
            //     ->orderBy('id', 'desc')->first();
            // $basic_punishments = ViolationTitle::with('punishments.namzeg')
            //     ->where('id', $vioaltion_title->id)
            //     ->get();
            // $basic_punishments = ViolationTitle::with('punishments.namzeg', 'punishments.related_punishments')
            //     ->where('violation_grade_id', $student_violation->violation_grade_id)
            //     ->where('id', $vioaltion_title->id)->get()
            //     ->flatMap(function ($violation_title) {
            //         return $violation_title->punishments->map(function ($punishment) {
            //             $basic_namazeg = collect([$punishment->namzeg]);
            //             $relative_basic_namazeg = $punishment->related_punishments->pluck('namzeg');
            //             return $basic_namazeg->concat($relative_basic_namazeg)->values();
            //         });
            //     })->flatten(1)->sortBy('id')->unique()->values();


            // $result = [
            //     'violation_title_name' => $vioaltion_title->violation_name->name,
            //     'violation_title_id' => $vioaltion_title->id,
            //     'basic_punishments' => $basic_punishments,
            //     'related_punishments' => []
            // ];
        }

        return $result;
    }



    // namazeggggggggggggggggggggggggggggggg
    public function store_punishment_data(Request $request, ViolationStudent $student_violation, ViolationTitle $violation_title, $form_id)
    {
        $violation_student_title = ViolationStudentTitle::where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $violation_title->id)->first();
        $violation_student_title->update(['status' => 'started']);
        $violation_student_punishment = ViolationStudentPunishment::with('namozeg')->where('violation_student_title_id', $violation_student_title->id)
            ->where('punishment_id', $form_id)->first();

        $namozegService = new NamozegFactoryProvider();

        $namozeg_version = $namozegService->store($student_violation->school_id, $violation_student_punishment, $request);

        $violation_student_punishment->update(['status' => 'done', 'namazeg_version_id' => $namozeg_version->id]);
        NamozegFactoryProvider::update_status_violationStudentTitle($violation_student_title->id);


        return response()->json(['message' => trans('api.record stored successflly')]);
    }


    public function update_punishment_data(Request $request, ViolationStudent $student_violation, ViolationTitle $violation_title, $form_id)
    {

        $violation_student_title = ViolationStudentTitle::where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $violation_title->id)->first();
        $violation_student_punishment = ViolationStudentPunishment::with('namozeg')->where('violation_student_title_id', $violation_student_title->id)
            ->where('punishment_id', $form_id)->first();
        $namozeg_version_id = $violation_student_punishment->namazeg_version_id;
        $namozegService = new NamozegFactoryProvider();
        $namozeg_version_id = $namozegService->update($namozeg_version_id, $violation_student_punishment, $request);

        $violation_student_punishment->update(['status' => 'done', 'namazeg_version_id' => $namozeg_version_id]);
        return response()->json(['message' => trans('api.record updated successflly')]);
    }


    public function get_punishment_details(Request $request, ViolationStudent $student_violation, ViolationTitle $violation_title, $form_id)
    {

        $violation_student_title = ViolationStudentTitle::where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $violation_title->id)->first();
        $violation_student_punishment = ViolationStudentPunishment::with('namozeg')->where('violation_student_title_id', $violation_student_title->id)
            ->where('punishment_id', $form_id)->first();
        $namozegService = new NamozegFactoryProvider();
        $namozeg_version = $namozegService->get($violation_student_punishment->namozeg->form_number, $student_violation->school_id, $request, $violation_student_punishment);

        return response()->json(['details' => $namozeg_version]);
    }

    public function get_types(GradeViolation $gradeViolation)
    {
        $types = $gradeViolation->types()->select('id', 'name')->get();
        return response()->json($types);
    }

    // namazeggggggggggggggggggggggggggggggg


    public function delete(ViolationStudent $violation_student)
    {
        $form_number = $violation_student->namozegVersion->namozeg?->form_number;
        $violation_student->delete();
        $this->ManagerlogActivity('ViolationStudentPunishment', 'store', $violation_student->student->school_id, $form_number);

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }


    public function get_228_options()
    {
        $options = NamazegProceduresFormOption::select('id', 'name')->get();
        return response()->json(['options' => $options]);
    }

    public function get_student_degrees(Student $student)
    {
        $data = StudentDegreesResource::collection($student->violationDegrees);
        $manager_name = SchoolEmployee::where('school_id', $student->school_id)->where('current_work_id', 1)->first()?->name;
        $manager_assistant_name = SchoolEmployee::where('school_id', $student->school_id)->where('current_work_id', 7)->first()?->name;

        return response()->json([
            'student_name' => $student->name,
            'class' => $student->schoolClass->className->name,
            'manager_name' => $manager_name,
            'manager_assistant_name' => $manager_assistant_name,
            'data' => $data
        ]);
    }
    public function update_student_degrees(UpdateViolationDegreeRequest $request, Student $student, StudentViolationDegrees $violation_degrees)
    {
        $violation_degrees->update($request->all());
        $form_number = $violation_degrees->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('StudentViolationDegrees', 'update', $violation_degrees->student->school_id, $form_number);

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    public function delete_student_violation_title(ViolationStudent $student_violation, $student_violation_title_id)
    {
        $student_violation_title = ViolationStudentTitle::with('punishments')->where('violation_student_id', $student_violation->id)
            ->where('violation_title_id', $student_violation_title_id)->firstOrFail();
        $student_violation_title->update(['status' => 'still']);
        $student_violation_title->punishments()->delete(); //ViolationStudentPunishment::where('violation_student_title_id', $student_violation_title->id)->get();
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }


    public function make_flag_done(ViolationStudent $student_violation)
    {
        $student_violation->update(['published' => 1]);
        return response()->json(['message' => 'Flag Saved successfully.']);
    }
}
