<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Supervision;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Http\Requests\ManagerDashboard\Supervision\SupervisionStoreRequest;
use App\Http\Requests\ManagerDashboard\Supervision\SupervisionUpdateRequest;
use App\Http\Resources\ManagerDashboard\Supervision\SupervisionResource;
use App\Jobs\SendSMSNotification;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\NotificationSettings\NotificationSchoolSetting;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Supervisor;
use App\Models\Namazeg;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Tymon\JWTAuth\Facades\JWTAuth;

class SupervisionController extends Controller
{
    use LogsActivity, NamazegTrait;
    /* to uses the class methods
        -you should be authenticated
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:supervisions']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request)
    {
        Helper::saveSupervisionSchedules($request->school_id);
        $data = SupervisionSchedul::with('supervisors')->where('school_id', $request->school_id);
        // Retrieve all query parameters
        $perPage = $request->per_page ?? 15;
        $filterData = SupervisionResource::collection($data->paginate($perPage));
        return response()->json([
            'supervision_schedul' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /* this method will return specific Model recored
        by using ID
    */
    public function getById($id)
    {
        $supervision = SupervisionSchedul::with('namozegVersion')->where('id', $id)->firstOrFail();
        $groupedData = $supervision->supervisors->groupBy('day_id');
        $follow_groupedData = $supervision->follow_supervisors?->groupBy('day_id');

        $formattedData = $groupedData->map(function ($dayData, $dayId) use ($follow_groupedData) {
            return [
                'day_id' => $dayId,
                'day' => $dayData->first()->day_name->name,
                'followers' => $follow_groupedData->isNotEmpty() ? $follow_groupedData[$dayId]->map(function ($entry) {
                    return [
                        'id' => $entry->id,
                        'school_employee_id' => $entry->school_employee_id,
                        'school_employee' => $entry->employee->name
                    ];
                })->values() : [],

                'data' => $dayData->groupBy('floor_id')->map(function ($floorData, $floorId) {
                    return [
                        'floor_id' => $floorId,
                        'floor' => $floorData->first()?->floor_name?->name,
                        'supervisors' => $floorData->map(function ($entry) {
                            return [
                                'id' => $entry->id,
                                'school_employee_id' => $entry->school_employee_id,
                                'school_employee' => $entry->employee->name
                            ];
                        })->values()
                    ];
                })->values()
            ];
        })->values();

        // وكيل الشئون المدرسية
        $supervisor_name = SchoolEmployee::where('school_id', $supervision->school_id)->where('current_work_id', 8)->first()?->name;
        $manager_name = SchoolEmployee::where('school_id', $supervision->school_id)->where('current_work_id', 1)->first()?->name;

        return response()->json([
            'title' => $supervision->title,
            'semester' => $supervision->semester->name,
            'manager_name' => $manager_name,
            'supervisor_name' => $supervisor_name,
            'form_number' => $supervision->namozegVersion?->namozeg?->form_number,
            'serial_number' => $supervision?->namozegVersion?->serial_number,
            'created_at' => $supervision->supervisors ? $supervision->created_at->format('Y/m/d') : __('api.not_created_yet'),
            'supervison' => $formattedData,
            'message' => trans('api.supervison details')
        ]);
    }

    /* this method will stord data to DB Model*/
    public function store(SupervisionStoreRequest $request)
    {
        $token = $request->bearerToken();
        if ($token) {
            $user = JWTAuth::toUser($token);
        }

        $supervision_schedul = SupervisionSchedul::findOrFail($request->supervision_schedule_id);
        foreach ($request->data as $data_per_day) {
            foreach ($data_per_day['data'] as $data_per_floor) {
                $school_employee_ids = is_array($data_per_floor['school_employee_id']) ? $data_per_floor['school_employee_id'] : [$data_per_floor['school_employee_id']];
                foreach ($school_employee_ids as $school_employee_id) {
                    Supervisor::create([
                        'supervision_schedule_id' => $request->supervision_schedule_id,
                        'school_employee_id' => $school_employee_id,
                        'day_id' => $data_per_day['day_id'],
                        'floor_id' => $data_per_floor['floor_id'],
                    ]);
                }
            }
        }
        /* store user that update table data*/
        $supervision_schedul->user_id = $user->id;
        $supervision_schedul->save();

        // ------------------------------- School ID -----------------------
        $school_id = $supervision_schedul->school_id;
        $form_number = $supervision_schedul->namozegVersion->namozeg->form_number;

        $this->ManagerlogActivity('Supervisor', 'store', $school_id, $form_number);

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /* this method will update specific Model recored
        by using ID
    */
    public function update(SupervisionUpdateRequest $request, $id)
    {
        $token = $request->bearerToken();
        if ($token) {
            $user = JWTAuth::toUser($token);
        }

        $namozeg = Namazeg::where('form_number', '49')->first();
        $supervision_schedul = SupervisionSchedul::findOrFail($id);
        if (!$supervision_schedul->namazeg_version_id) {
            $namozeg_version_id = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $supervision_schedul->school_id
            )->id;
        } else {
            $namozeg_version_id = $supervision_schedul->namazeg_version_id;
        }
        $supervision_schedul->update([
            'title' => $request->title ? $request->title : $supervision_schedul->title,
            'namazeg_version_id' => $namozeg_version_id,
            'user_id' => $user->id,
        ]);

        $super_vision = Supervisor::where('supervision_schedule_id', $id)->delete();
        $notification_setting_shift_schedual = NotificationSchoolSetting::where('school_id', $supervision_schedul->school_id)
            ->where('notification_setting_id', 7)
            ->first();
        foreach ($request->data as $data_per_day) {
            // المتابعين 
            foreach ($data_per_day['followers'] as $follower) {
                $super_visor = Supervisor::Create(
                    [
                        'supervision_schedule_id' => $id,
                        'day_id' => $data_per_day['day_id'],
                        'school_employee_id' => $follower,
                        'type' => 'follow',
                    ]
                );
                if ($notification_setting_shift_schedual->messages) {
                    $message_text = "لديك اشراف هذا اليوم. نرجو الالتزام بالموعد المحدد.";
                    $dates = SemesterWeekDay::where('day_id', $data_per_day['day_id'])
                        ->where('semester_id', $supervision_schedul->semester_id)
                        ->pluck('date')->toArray();
                    foreach ($dates as $date) {
                        $sendAt = Carbon::createFromFormat('d/m/Y', $date)->setTime(5, 0, 0);
                        SendSMSNotification::dispatch($super_visor->employee->phone, $message_text, $user->manager_id)->delay($sendAt);
                    }
                }
            }
            // المشرفين
            foreach ($data_per_day['data'] as $data_per_floor) {
                $school_employee_ids = is_array($data_per_floor['school_employee_id']) ? $data_per_floor['school_employee_id'] : [$data_per_floor['school_employee_id']];
                foreach ($school_employee_ids as $school_employee_id) {
                    $super_visor = Supervisor::Create(
                        [
                            'supervision_schedule_id' => $id,
                            'day_id' => $data_per_day['day_id'],
                            'floor_id' => $data_per_floor['floor_id'],
                            'school_employee_id' => $school_employee_id,
                        ]
                    );
                    if ($notification_setting_shift_schedual->messages) {
                        $message_text = "لديك اشراف هذا اليوم. نرجو الالتزام بالموعد المحدد.";
                        $dates = SemesterWeekDay::where('day_id', $data_per_day['day_id'])
                            ->where('semester_id', $supervision_schedul->semester_id)
                            ->pluck('date')->toArray();
                        foreach ($dates as $date) {
                            $sendAt = Carbon::createFromFormat('d/m/Y', $date)->setTime(5, 0, 0);
                            SendSMSNotification::dispatch($super_visor->employee->phone, $message_text, $user->manager_id)->delay($sendAt);
                        }
                    }
                }
            }
        }
        // ------------------------------- School ID -----------------------
        $school_id = $supervision_schedul->school_id;
        $form_number = $supervision_schedul->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('Supervisor', 'update', $school_id, $form_number);
        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will delete specific Model recored
        by using ID
    */
    public function delete($id)
    {
        $SupervisionSchedul = SupervisionSchedul::findOrFail($id);
        $school_id = $SupervisionSchedul->school_id;
        $SupervisionSchedul->forceDelete();
        $form_number = $SupervisionSchedul->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('Supervisor', 'delete', $school_id, $form_number);
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }

    /* this method will archive specific Model recored
        by using ID
    */
    public function archive($id)
    {
        $SupervisionSchedul = SupervisionSchedul::findOrFail($id);
        $school_id = $SupervisionSchedul->school_id;
        $SupervisionSchedul->delete();

        $form_number = $SupervisionSchedul->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('Supervisor', 'archive', $school_id, $form_number);
        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    /* this method will restore specific Model recored
        by using ID
    */
    public function restore($id)
    {
        $SupervisionSchedul = SupervisionSchedul::findOrFail($id);
        $school_id = $SupervisionSchedul->school_id;
        $SupervisionSchedul->restore();
        $form_number = $SupervisionSchedul->namozegVersion->namozeg->form_number;
        $this->ManagerlogActivity('Supervisor', 'restore', $school_id, $form_number);
        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}
