<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Settings\Subscriptions\Sms;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\AdminDashboard\Coupons\Coupon;
use App\Models\AdminDashboard\Products\Product;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Settings\Subscription;

class SmsSubscriptionController extends Controller
{
    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request, School $school)
    {

        $data = $request->validate([
            'product_id' => ['required','integer','exists:products,id'],
            'coupon_id' => 'nullable|exists:coupons,id',
        ]);

        $product = Product::where('id',$data['product_id'])->firstOrfail();
        
        
        $subscription_fee =  $product->price;


        $tax_fees = $subscription_fee * 0.15;
        $tax_fees = round($tax_fees);
        $tax_fees = (int)$tax_fees;


        if (isset($data['coupon_id'])) {
            $coupon = Coupon::where('id', $data['coupon_id'])->firstOrFail();

            // Calculate the discount amount
            $discount_amount = ($coupon->discount_type === 'fixed')
                ? min($coupon->discount_value, $subscription_fee) // Ensure discount doesn't exceed fee
                : $subscription_fee  * $coupon->discount_value / 100;
   
        }

        $discount_amount =   $discount_amount ?? 0;

        // Calculate total price, ensuring it does not go negative
        $total_price = max(0, $subscription_fee  - $discount_amount);

       $subscription = Subscription::create([
            'user_id' => auth()->user()->id,
            'product_id' => $product->id,
            'status' =>  'not_subscribed',
            'service_type' => 'sms',
            'subscription_fee' => $subscription_fee,
            'tax_fees' => $tax_fees,
            'coupon_id' => $data['coupon_id'] ?? null,
            'coupon_discount' => $discount_amount,
            'paid_status'=> 'Unpaid',
            'total_price' => $total_price,

        ]);

        return response()->json([
            'message' => 'تمت عملية بدء الدفع بنجاح',
            'subscription_id' => $subscription->id,
            'Subtotal' => $subscription_fee,
            'tax_fees' => $tax_fees,
            'discount_amount' => $discount_amount,
            'total_price' =>   $total_price,
            'subscription_type' => $product->name
        ]);
    }

}
