<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Reports;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;

use App\Http\Resources\ManagerDashboard\Reports\EducationalAdmisnstrative\EducationalAdminstrativeAlertReportResource;
use App\Http\Resources\ManagerDashboard\Reports\StudentAdminstrativeReport\StudentAdminstrativeAbsentLateReportResource;
use App\Http\Resources\ManagerDashboard\Reports\StudentAdminstrativeReport\StudentAdminstrativeWorkReportResource;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Reports\EducationalAdmisnstrativeReport\EducationalAdminstrativeAlert;
use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeAbsentLate;
use App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeWork;
use Illuminate\Http\Request;
use JWTAuth;

use App\Models\Namazeg;
use App\Traits\NamazegTrait;


class StudentAdmisnstrativeReportController extends Controller
{

    use NamazegTrait;

    public function storeWorkReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',8)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $data = $request->all();
        $data['report_category_id']= 14;
        $data['namazeg_version_id'] = NULL;
        $report = StudentAdminstrativeWork::create($data);
        $report = new StudentAdminstrativeWorkReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    public function getWorkReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',8)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $report= StudentAdminstrativeWork::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $report = new StudentAdminstrativeWorkReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report details')]);
    }

    public function getAllWorkReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = StudentAdminstrativeWork::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','report_type']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeWork', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        if ($request->report_type) {
            $data->where('report_type', $request->report_type);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = StudentAdminstrativeWorkReportResource::collection($data->paginate($perPage));

        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }

    public function storeAbsentLateReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',8)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $data = $request->all();
        $data['report_category_id']= 15;
        $data['namazeg_version_id'] = NULL;
        $report = StudentAdminstrativeAbsentLate::create($data);

        /* handel namzeg of each report depend on type*/
        $namazegMappings = [
            'absent_students' => [
                'daily' => 267,
                'weekly' => 268,
                'classy' => 269,
            ],
            'late_students' => [
                'daily' => 270,
                'weekly' => 271,
                'classy' => 272,
            ],
        ];

        $category = $report->report_category;
        $type = $report->report_type ?? null;

        if (isset($namazegMappings[$category])) {
            $namazegId = $namazegMappings[$category][$type] ?? null;
            if ($namazegId) {
                $this->handelNamazeg($report->id, $namazegId);
            }
        }

        $report = new StudentAdminstrativeAbsentLateReportResource($report);

        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    /* function used to return School Status Statistics Report by id */
    public function getAbsentLateReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }

        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',8)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }
        $report= StudentAdminstrativeAbsentLate::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $reportCategory = $report->report_category;
        $report = new StudentAdminstrativeAbsentLateReportResource($report);
        return response()->json(['report'=>$report,'report_category'=>$reportCategory,'message' => trans('api.Report details')]);
    }

    public function getAllAbsentLateReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = StudentAdminstrativeAbsentLate::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','report_type']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\StudentAdmisnstrativeReport\StudentAdminstrativeAbsentLate', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        if ($request->report_type) {
            $data->where('report_type', $request->report_type);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = StudentAdminstrativeAbsentLateReportResource::collection($data->paginate($perPage));
        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }

    private function handelNamazeg($reportId,$formNumber){
        $report = StudentAdminstrativeAbsentLate::find($reportId);
        /** create or update  namozg version for this table*/
        $namozeg = Namazeg::where('form_number', $formNumber)->first();
        $namazeg_version_id = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $report->school_id
        )->id;

        /* store namozeg version for this record*/
        $report->update(['namazeg_version_id' => $namazeg_version_id]);
    }
}
