<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Reports;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Resources\ManagerDashboard\Reports\SchoolAdminstrativeReport\SchoolAdminstrativeAbsentLateReportResource;
use App\Http\Resources\ManagerDashboard\Reports\SchoolAdminstrativeReport\SchoolAdminstrativeWorkReportResource;
use App\Http\Resources\School\SchoolStudentResource;
use App\Models\AdminDashboard\School\ClassName;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeAbsentLate;
use App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeWork;
use Illuminate\Http\Request;
use JWTAuth;
use Carbon\Carbon;

use App\Models\Namazeg;
use App\Traits\NamazegTrait;

class SchoolAdmisnstrativeReportController extends Controller
{
    use NamazegTrait;

    public function storeWorkReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',7)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $data = $request->all();
        $data['report_category_id']= 12;
        $data['namazeg_version_id'] = NULL;
        $report = SchoolAdminstrativeWork::create($data);
        $report = new SchoolAdminstrativeWorkReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    public function getWorkReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',7)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $report= SchoolAdminstrativeWork::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $report = new SchoolAdminstrativeWorkReportResource($report);
        return response()->json(['report'=>$report,'message' => trans('api.Report details')]);
    }

    public function getAllWorkReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = SchoolAdminstrativeWork::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','report_type']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeWork', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        if ($request->report_type) {
            $data->where('report_type', $request->report_type);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolAdminstrativeWorkReportResource::collection($data->paginate($perPage));

        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }

    public function storeAbsentLateReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',7)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $data = $request->all();
        $data['report_category_id']= 13;

        $data['date'] = date('d/m/Y');
        $data['date_type'] = 'coptic';
        $data['namazeg_version_id'] = NULL;
        $report = SchoolAdminstrativeAbsentLate::create($data);


        /* handel namzeg of each report depend on type*/
        $namazegMappings = [
            'absent_teachers' => [null => 264],
            'late_teachers' => [null => 265],
        ];

        $category = $report->report_category;
        $type = $report->report_type ?? null;

        if (isset($namazegMappings[$category])) {
            $namazegId = $namazegMappings[$category][$type] ?? null;
            if ($namazegId) {
                $this->handelNamazeg($report->id, $namazegId);
            }
        }

        $report = new SchoolAdminstrativeAbsentLateReportResource($report);

        return response()->json(['report'=>$report,'message' => trans('api.Report has been created!')]);
    }

    /* function used to return School Status Statistics Report by id */
    public function getAbsentLateReport(Request $request){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$request->school_id)->firstOrFail();
        $schoolEmployee = SchoolEmployee::where('school_id',$school->id)->where('current_work_id',7)->first();
        if(!$schoolEmployee){
            return response()->json(['message' => trans('api.School employee not found!')]);
        }

        $report= SchoolAdminstrativeAbsentLate::where('id',$request->report_id)->where('school_id',$school->id)->firstOrFail();
        $reportCategory = $report->report_category;
        $report = new SchoolAdminstrativeAbsentLateReportResource($report);
        return response()->json(['report'=>$report,'report_category'=>$reportCategory,'message' => trans('api.Report details')]);
    }

    public function getAllAbsentLateReports(Request $request,$schoolId){
        $token = $request->bearerToken();
        if($token){
            $user = JWTAuth::toUser($token);
        }
        $school = School::where('user_id',$user->id)->where('id',$schoolId)->firstOrFail();

        // Start with the base query
        $data = SchoolAdminstrativeAbsentLate::query();
        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return !in_array($key, ['per_page', 'date','date_type','report_category']);
        }, ARRAY_FILTER_USE_KEY);
        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Reports\SchoolAdmisnstrativeReport\SchoolAdminstrativeAbsentLate', $filterData);
        }
        $data->where('school_id', $school->id);

        // custom filter////
        if ($request->date) {
            $formattedDate = Carbon::createFromFormat('d/m/Y', $request->date)->toDateString();
            $data->whereDate('created_at', $formattedDate)->where('date_type',$request->date_type);
        }

        if ($request->report_category) {
            $data->where('report_category', $request->report_category);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;
        $filterData = SchoolAdminstrativeAbsentLateReportResource::collection($data->paginate($perPage));

        return response()->json(['reports'=>$filterData,'message' => trans('api.list of all reports')]);
    }


    private function handelNamazeg($reportId,$formNumber){
        $report = SchoolAdminstrativeAbsentLate::find($reportId);
        /** create or update  namozg version for this table*/
        $namozeg = Namazeg::where('form_number', $formNumber)->first();
        $namazeg_version_id = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $report->school_id
        )->id;

        /* store namozeg version for this record*/
        $report->update(['namazeg_version_id' => $namazeg_version_id]);
    }
}
