<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Messages;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Messages\MessageStoreRequest;
use App\Http\Requests\ManagerDashboard\Messages\MessageUpdateRequest;
use App\Http\Resources\ManagerDashboard\Messages\MessageHistoryResource;
use App\Http\Resources\ManagerDashboard\Messages\MessageResource;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\Student;
use App\Models\ManagerDashboard\Messages\MessageReciver;
use App\Models\ManagerDashboard\Messages\Message;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\User;
use App\Traits\LogsActivity;
use App\Traits\SmsTrait;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use JWTAuth;
use Tymon\JWTAuth\Exceptions\JWTException;

use Illuminate\Http\Request;

class MessagesController extends Controller
{
    use LogsActivity,SmsTrait;
    /* to uses the class methods
        -you should be authenticated 
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        // $this->middleware(['auth:api', 'jwt.verify','permission:messgaes']);
    }

    /*
        -this method will return all Model recoreds
    */
    public function getAll(Request $request, $school_id)
    {
        // Initialize the query with the school_id
        $data = Message::where('school_id', $school_id);

        // Retrieve all query parameters
        $queryParams = $request->query();
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'name';
        }, ARRAY_FILTER_USE_KEY);
        $filterData['school_id'] = $school_id;

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\Messages\Message', $filterData);
        }

        // Custom filter date
        if (isset($queryParams['date_type']) && isset($queryParams['date'])) {
            $date = $queryParams['date'];
            if ($queryParams['date_type'] == "hijri") {
                $date = Helper::getCoptic($queryParams['date']);
            }
            $date = Carbon::createFromFormat('d/m/Y', $date)->format('Y-m-d');
            $data = $data->whereDate('updated_at', $date);
        }

        // Custom filter by name
        if ($request->name) {
            // Get IDs of students 
            $student_ids = Student::where('name', 'like', '%' . $request->name . '%')
                ->pluck('id')
                ->toArray();
            $student_message_ids = MessageReciver::whereIn('user_id', $student_ids)->where('user_type', 'student')
                ->pluck('message_id')
                ->toArray();

            // Get IDs of employees 
            $employee_ids = SchoolEmployee::where('name', 'like', '%' . $request->name . '%')
                ->pluck('id')
                ->toArray();
            $employee_message_ids = MessageReciver::whereIn('user_id', $employee_ids)->where('user_type', 'employee')
                ->pluck('message_id')
                ->toArray();
            $message_ids = array_merge($student_message_ids, $employee_message_ids);
            $data = $data->whereIn('id', $message_ids);
        }


        $perPage = $queryParams['per_page'] ?? 15;
        $paginatedData = $data->paginate($perPage);

        // Transform the results using MessageResource
        $filterData = MessageResource::collection($paginatedData);

        return response()->json([
            'messages' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /*
        -this method will return all Model recoreds
    */
    public function top_messages($school_id)
    {
        $user_id = auth()->id();
        $subscribtion = Subscription::with('product')
                ->where('user_id', $user_id)
                ->where('paid_status', 'paid')
                ->where('status', 'subscribed')
                ->latest()->first();
        $messages = Message::with('receptors')->where('school_id', $school_id)->whereDate('updated_at', Carbon::today())
            ->orderBy('id', 'Desc')->take(20)->get();
        $messages_resource = MessageResource::collection($messages);

        return response()->json([
            'n_remaining' => $subscribtion ? $subscribtion->product->messages_count - $subscribtion->messages_consumed : 0,
            'n_package' => $subscribtion ? $subscribtion->product->messages_count : 0,
            'date' => Carbon::today()->translatedFormat('Y M d', 'ar'),
            'n_messages' => count($messages_resource),
            'messages_history' => $messages_resource,
            'product_name' => $subscribtion ? ($subscribtion->product ? $subscribtion->product->name : 'testing_package') : 'Experimental',
        ]);
    }


    /* this method will stord data to DB Model*/
    public function store(MessageStoreRequest $request)
    {
        $user = auth()->user();
        $user_id = $user->id;
        $subscribtion = Subscription::with('product')->where('user_id', $user_id)
            ->where('paid_status', 'paid')
            ->where('status', 'subscribed')
            ->latest()->first();
        if (!$subscribtion) {
            return response()->json(["message" => __("api.Your Message package not enouph for your messages.")], 422);
        }
        $remaining = $subscribtion->product->messages_count - $subscribtion->messages_consumed;
        if ($remaining == 0) {
            
            // $subscribtion->update(['status' => 'finished']);
                // Abobasha
            $subscribtion->update(['status' => 'not_subscribed']);
            return response()->json(["message" => __("api.Your Message package not enouph for your messages.")], 422);
        }
        if (count($request->reciver_ids) > $remaining) {
            return response()->json(["message" => __("api.Your Message package not enouph for your messages.")], 422);
        }
        $message = Message::create([
            'message' => $request->message,
            'type' => 'handy',
            'school_id' => $request->school_id,
        ]);
        $recivers = Student::whereIn('id', $request->reciver_ids)->get();
        foreach ($request->reciver_ids as $reciver_id) {
            
            MessageReciver::create([
                'message_id' => $message->id,
                'user_id' => $reciver_id,
                'user_type' => $request->user_type
            ]);

            $this->sendSMSNotification($recivers->where('id', $reciver_id)->first()?->phone, $request->message, $user->manager_id);
        }
        $subscribtion->increment('messages_consumed', count($request->reciver_ids));

        // ------------------------------- School ID -----------------------
        $school_id = $request->school_id;
        $this->ManagerlogActivity('Message', 'store', $school_id, '/manager-messages/top/' . $school_id);
        $subscripe_remaining = $remaining- count($request->reciver_ids);
        $message_text = "تم ارسالة الرسالة بنجاح, متبقى ". $subscripe_remaining .' رسالة.';
        return response()->json(['remaining_messages'=> $message_text,'message' => trans('api.record stored successflly')]);
    }
    /* this method will stord data to DB Model*/
    public function resend(MessageUpdateRequest $request, $notification_id)
    {
        // Old Messgaes
        $oldMessage = Message::findOrFail($notification_id);
        $user_type = MessageReciver::where('message_id', $notification_id)->first()->user_type;

        $user_id = auth()->id();
        $school_id = auth()->user()->schools()->first()->id;
        $subscribtion = Subscription::with('product')->where('user_id', $user_id)
            ->where('paid_status', 'paid')
            ->whereIn('status', ['subscribed','Experimental'])->latest()->firstOrFail();
        $remaining = $subscribtion->product->messages_count - $subscribtion->messages_consumed;
        if ($remaining == 0) {
            // $subscribtion->update(['status' => 'finished']);
                    //Abobasha
            $subscribtion->update(['status' => 'not_subscribed']);
            
            return response()->json(["message" => __("api.Your Message package not enouph for your messages.")], 422);
        }
        if (count($request->reciver_ids) > $remaining) {
            return response()->json(["message" => __("api.Your Message package not enouph for your messages.")], 422);
        }


        // New Messgaes
        $message = Message::create([
            'message' => $oldMessage->message,
            'type' => $oldMessage->type,
            'school_id' => $oldMessage->school_id,
        ]);
        $recivers = Student::whereIn('id', $request->reciver_ids)->get();

        foreach ($request->reciver_ids as $reciver_id) {
            MessageReciver::create([
                'message_id' => $message->id,
                'user_id' => $reciver_id,
                'user_type' => $user_type
            ]);
            $this->sendSMSNotification($recivers->where('id', $reciver_id)->first()?->phone, $request->message, $user->manager_id);

        }
        // ------------------------------- School ID -----------------------
        $school_id = $oldMessage->school_id;
        $this->ManagerlogActivity('Message', 'resend', $school_id, '/manager-messages/top/' . $school_id);
        $subscripe_remaining = $remaining - count($request->reciver_ids);
        $message_text = "تم ارسالة الرسالة بنجاح, متبقى " . $subscripe_remaining . ' رسالة.';
        return response()->json(['remaining_messages' => $message_text, 'message' => trans('api.record stored successflly')]);
    }

    /* this method will stord data to DB Model*/
    // public function sms_store(MessageStoreRequest $request)
    // {
    //     $message = Message::create([
    //         'message' => $request->message,
    //         'type' => 'sms'
    //     ]);

    //     foreach ($request->reciver_ids as $reciver_id) {
    //         MessageReciver::create([
    //             'message_id' => $message->id,
    //             'user_id' => $reciver_id,
    //         ]);
    //     }
    //     // ------------------------------- School ID -----------------------
    //     $school_id = $request->school_id;
    //     $this->ManagerlogActivity('Message', 'store', $school_id, '/manager-messages/top/' . $school_id);
    //     return response()->json(['message' => trans('api.record stored successflly')]);
    // }


    /* this method will delete specific Model recored 
        by using ID
    */
    public function delete($id)
    {
        $notification = Message::findOrFail($id);
        $school_id = $notification->school_id;
        $notification->forceDelete();
        $this->ManagerlogActivity('Message', 'delete', $school_id);

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }

    /* this method will archive specific Model recored 
        by using ID
    */
    public function archive($id)
    {
        $notification = Message::findOrFail($id);
        $school_id = $notification->school_id;
        $notification->delete();
        $this->ManagerlogActivity('Message', 'archive', $school_id);
        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    /* this method will restore specific Model recored 
        by using ID
    */
    public function restore($id)
    {
        $notification = Message::findOrFail($id);
        $school_id = $notification->school_id;
        $notification->restore();
        $this->ManagerlogActivity('Message', 'restore', $school_id);
        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}
