<?php

namespace App\Http\Controllers\Api\ManagerDashboard\LetterAndAlart;

use App\Helpers\Helper;
use App\Helpers\HelperNotification;
use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\LettersAndAlarts\StoreLetterRequest;
use App\Http\Requests\ManagerDashboard\LettersAndAlarts\UpdateLetterRequest;
use App\Http\Resources\ManagerDashboard\LetterAndAlart\AlertResource;
use App\Http\Resources\ManagerDashboard\LetterAndAlart\LetterResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\OfficialSpeeches\Alert;
use App\Models\ManagerDashboard\OfficialSpeeches\Letter;
use App\Models\Namazeg;
use App\Traits\LogsActivity;
use App\Traits\NamazegTrait;
use Illuminate\Http\Request;

class LetterController extends Controller
{
    use LogsActivity, NamazegTrait;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:letters']);
    }

    public function index()
    {
        $officialLetter = LetterResource::collection(Letter::where('type', 'official')->get());
        $warningLetter  = LetterResource::collection(Letter::where('type', 'warning')->get());
        $verbalAlerts   = AlertResource::collection(Alert::with('employee')->where('type', 'verbal')->get());
        $writtenAlerts  = AlertResource::collection(Alert::with('employee')->where('type', 'written')->get());
        return response()->json([
            'officialLetter' => $officialLetter,
            'warningLetter' => $warningLetter,
            'verbalAlerts' => $verbalAlerts,
            'writtenAlerts' => $writtenAlerts,
            'message' => trans('api.list of all available records'),
        ]);
    }


    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request, School $school)
    {

        // Start with the base query
        $data = Letter::query()->where('school_id', $school->id);;

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Filter data is directly from query parameters, excluding `per_page`
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\ManagerDashboard\OfficialSpeeches\Letter', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = LetterResource::collection($data->paginate($perPage));


        return response()->json([
            'letters' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreLetterRequest $request, School $school)
    {
        $data = $request->validated();

        if ($data['date_type'] === 'hijri') {
            $data['date'] = Helper::getCoptic($data['date']);
            $data['date_type'] = 'coptic';
        }

        switch ($request->type) {
            case "warning":
                $form_number = 38;
                break;
            case "official":
                $form_number = 41;
                break;
            default:
        };

        $namozeg = Namazeg::where('form_number', $form_number)->first();

        $namozeg_version_id = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school->id
        )->id;

        $data['namazeg_version_id'] = $namozeg_version_id;

        $data['school_id'] = $school->id;

        $Letter = new Letter();
        $Letter->fill($data);

        $Letter->save();


        if ($request->type == "warning") {
            HelperNotification::create_warning_letter_notifications($school->id);
        }

        // ------------------------------- School ID -----------------------

        $this->ManagerlogActivity('Letter', 'store', $school->id);


        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Display the specified resource.
     */
    public function getById(School $school, Letter $letter)
    {

        $letter = new LetterResource($letter);
        return response()->json(['letter' => $letter], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateLetterRequest $request, School $school, Letter $letter)
    {

        $validatedData = $request->validated();

        if ($request->date_type) {
            if ($validatedData['date_type'] === 'hijri') {
                $validatedData['date'] = Helper::getCoptic($validatedData['date']);
                $validatedData['date_type'] = 'coptic';
            }
        }
        $letter->update($validatedData);


        $this->ManagerlogActivity('Letter', 'update', $school->id);

        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }
    /**
     * soft Delete the specified resource from storage.
     */
    public function archive(School $school, Letter $letter)
    {

        $letter->delete();
        $this->ManagerlogActivity('Letter', 'archive',  $school->id);

        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(School $school, Letter $letter)
    {

        $letter->forceDelete();

        $this->ManagerlogActivity('Letter', 'delete',  $school->id);

        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }
    /**
     * restore the specified resource from storage.
     */
    public function restore(School $school, Letter $letter)
    {

        $letter->restore();
        $this->ManagerlogActivity('Letter', 'restore', $school->id);
        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }
}
