<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\SupervisionCommittees;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\SupervisionCommittees\SupervisionAssignmentRequest;
use App\Http\Requests\ManagerDashboard\Exams\SupervisionCommittees\UpdateSupervisionAssignmentRequest;
use App\Http\Resources\ManagerDashboard\Exams\SupervisionCommittees\CommitteeResource;
use App\Http\Resources\ManagerDashboard\Exams\SupervisionCommittees\SupervisionResource;
use App\Models\AdminDashboard\School\CurrentWork;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\ExamSupervisionCommittee;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\SupervisionAssignment;
use App\Models\ManagerDashboard\Exams\SupervisionCommittees\SupervisionAssignmentMember;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class SupervisionCommitteeController extends Controller
{
    use  NamazegTrait;
    public function getAllCommittees(School $school)
    {

        // Retrieve committees with assignments for the specific school
        $supervisionAssignments = SupervisionResource::collection(
            ExamSupervisionCommittee::with(['assignment' => function ($query) use ($school) {
                $query->where('school_id', $school->id); // Filter assignments to the correct school
            }])->get()

        );

        return response()->json(['supervisionAssignments' => $supervisionAssignments]);
    }

    public function show(School $school, ExamSupervisionCommittee $committee)
    {
        $assignmentData = [
            62 => [
                'assignment_works' => ['رئيساً للجنة', 'نائبا للرئيس', 'عضو', 'عضو', 'عضو', 'عضو', 'عضو'],
                'work_ids' => [6, 7, 8, 11, 2, 2, 2],
            ],
            63 => [
                'assignment_works' => ['رئيساً للجنة', 'عضو', 'عضو'],
                'work_ids' => [8, 2, 2],
            ],
            64 => [
                'assignment_works' => ['رئيساً للجنة', 'عضو', 'عضو', 'عضو'],
                'work_ids' => [7, 6, 2, 2],
            ],
            65 => [
                'assignment_works' => ['رئيساً للجنة', 'عضو', 'عضو'],
                'work_ids' => [6, 2, 2],
            ],
            66 => [
                'assignment_works' => ['رئيساً للجنة', 'عضو', 'عضو'],
                'work_ids' => [6, 2, 2],
            ],

        ];

        // Get assignment works and work IDs for the specific form number 
        $assignmentWorks = $assignmentData[$committee->assignment_form_number]['assignment_works'] ?? [];
        $currentWorkIds = $assignmentData[$committee->assignment_form_number]['work_ids'] ?? null;


        // Fetch the works based on the work_ids
        $currentWorks = CurrentWork::with(['employees' => function ($query) use ($school) {
            $query->where('school_id', $school->id);
        }])
            ->select('id', 'job_title')
            ->whereIn('id', $currentWorkIds)
            ->get();

        // Reorder and duplicate the works based on the order in work_ids
        $currentWorks = collect($currentWorkIds)->map(function ($workId) use ($currentWorks) {
            return $currentWorks->firstWhere('id', $workId);
        });


        // Define the default work ids to fetch employees if current work has no employees
        $defaultWorkIds = [1, 6, 7, 8];

        // Loop through currentWorks and check if any work has no employees
        $currentWorks->each(function ($work) use ($defaultWorkIds) {
            if ($work->employees->isEmpty()) {
                // If no employees for the current work, fetch from defaultWorkIds
                $defaultWork = CurrentWork::with(['employees' => function ($query) {
                    $query->where('school_id', auth()->user()->school_id);
                }])
                    ->select('id', 'job_title')
                    ->whereIn('id', $defaultWorkIds)
                    ->first();

                // Replace empty employees with the fetched employees from the default work
                if ($defaultWork && !$work->employees->isNotEmpty()) {
                    $work->employees = $defaultWork->employees;
                }
            }
        });


        // Pass current work, assignment works, and flag to CommitteeResource
        $committeeResource = new CommitteeResource($committee, $currentWorks, $assignmentWorks, true);

        return response()->json([
            'committee' => $committeeResource,
            'message' => trans('api.committee details')
        ], 200);
    }


    public function storeAssignment(SupervisionAssignmentRequest $request, School $school, ExamSupervisionCommittee $committee)
    {

        $data = $request->validated();

        try {
            $namozeg = Namazeg::where('form_number', $committee->assignment_form_number)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg Not Found for this committee form number in namazeg table .'], 404);
        }

        // Check if a NamazegVersion already exists for the school and namozeg_id
        $existing_version = NamazegVersion::where('namazeg_id', $namozeg->id)
            ->where('school_id', $school->id)
            ->first();

        if (!$existing_version) {
            // If no version exists, create a new one using the trait method
            $namozeg_version = $this->storeNamazegVersion(
                $namozeg->id,
                $namozeg->internal_extenral,
                $school->id
            );
        } else {
            // Use the existing version
            $namozeg_version = $existing_version;
        }
        // Find or create a new assignment for the committee
        $assignment = SupervisionAssignment::updateOrCreate(
            [
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school->id,
                'committee_id' => $committee->id,
                'round' => $data['round'] ?? 'الأول',
            ]
        );
        // Delete all members related to this assignment before adding new ones
        SupervisionAssignmentMember::where('assignment_id', $assignment->id)->delete();

        foreach ($data['members'] as $member) {
            SupervisionAssignmentMember::updateOrCreate([
                'assignment_id' =>  $assignment->id,
                'employee_id' => $member['employee_id'],
                'assignment_work' => $member['assignment_work'],
                'mission' => $member['mission'] ?? null,
            ]);
        }

        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    public function updateAssignment(UpdateSupervisionAssignmentRequest $request, School $school, SupervisionAssignment $assignment)
    {
        $data = $request->validated();

        $assignment->update(['round' => $data['round']]);

        // Delete all members related to this assignment before adding new ones
        SupervisionAssignmentMember::where('assignment_id', $assignment->id)->delete();

        foreach ($data['members'] as $member) {
            SupervisionAssignmentMember::updateOrCreate([
                'assignment_id' =>  $assignment->id,
                'employee_id' => $member['employee_id'],
                'assignment_work' => $member['assignment_work'],
                'mission' => $member['mission'] ?? null,
            ]);
        }

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    public function deleteAssignment(School $school, SupervisionAssignment $assignment)
    {

        $assignment->delete();
        SupervisionAssignmentMember::where('assignment_id', $assignment->id)->delete();
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
