<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\StudentCommittees;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\StudentCommittes\StoreAutomaticCommitteeRequest;
use App\Http\Requests\ManagerDashboard\Exams\StudentCommittes\StoreCommitteeDataRequest;
use App\Http\Requests\ManagerDashboard\Exams\StudentCommittes\StoreManualCommitteeRequest;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Services\Exams\ClassService;
use App\Services\Exams\CommitteeService;
use App\Traits\NamazegTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class StudentCommitteeController extends Controller
{
    use  NamazegTrait;

    protected $classService;

    protected $committeeService;

    public function __construct(ClassService $classService, CommitteeService $committeeService)
    {
        $this->classService = $classService;
        $this->committeeService = $committeeService;
    }

    public function getSchoolClasses(School $school)
    {
        return $this->classService->getSchoolClasses($school);
    }

    public function getExamStudentsCount(School $school)
    {

        return $this->classService->getExamStudentsCount($school);
    }

    //   تشكيل لجنه من نفس الصف
    public function storeAutomaticCommittees(StoreAutomaticCommitteeRequest $request, School $school)
    {
        try {
            $data = $request->validated();

            $committee = $this->committeeService->createAutomaticCommittees($data, $school);

            return response()->json([
                'message' => 'تم تشكيل اللجنة بنجاح',
                'committee' => $committee,
            ]);
        } catch (\Exception $e) {

            return response()->json(['error' => 'حدث خطأ أثناء تشكيل اللجنة.'], 500);
        }
    }
    // تشكيل لجنة يدوية
    public function storeManualCommittees(StoreManualCommitteeRequest $request, School $school)
    {
        try {
            $data = $request->validated();

            $this->committeeService->createManualCommittees($data, $school);

            return response()->json(['message' => 'تم تشكيل اللجان بنجاح']);
        } catch (\Exception $e) {

            return response()->json(['error' => 'حدث خطأ أثناء تشكيل اللجان.'], 500);
        }
    }
    // اضافة الطلاب  للجنة يدوية

    public function assignManualCommitteeStudents(StoreCommitteeDataRequest $request, School $school, StudentCommittee $committee)
    {
        try {
            $data = $request->validated();
    
            $this->committeeService->assignManualCommitteeStudents($data, $committee);
    
            return response()->json(['message' => 'تم اضافة الطلاب للجنة بنجاح']);
        } catch (\Exception $e) {
            // Log the error for debugging
            Log::error('Error assigning students: ' . $e->getMessage());
    
            // Return the actual error message
            return response()->json(['error' => $e->getMessage()], 422);
        }
    }

    public function getAllCommittees(School $school)
    {
        return $this->committeeService->getAllCommittees($school);
    }

    public function getCommitteeLocations(School $school)
    {

        return $this->classService->getCommitteeLocations($school);
    }

    public function show(School $school,StudentCommittee $committee)
    {
        
        return $this->committeeService->getCommitteeDetails($school,$committee);
    }

    public function getRemainingStudentsSummary(School $school , SchoolSemester $semester)
    {
      
        return $this->committeeService->getRemainingStudentsSummary($school,$semester);
    }

    public function destroy(School $school, StudentCommittee $committee)
    {
        try {
            $this->committeeService->deleteCommittee($school, $committee);

            return response()->json(['message' => trans('تم حذف  تشكيل اللجنة بنجاح')]);
        } catch (\Exception $e) {
           
            return response()->json(['error' => 'حدث خطأ برجاء المحاولة لاحقا.'], 500);
        }
    }

    public function deleteAllCommittees(School $school, SchoolSemester $semester)
    {
        try {
            $this->committeeService->deleteAllCommittees($school, $semester);

            return response()->json(['message' => 'تم حذف جميع اللجان لهذا الفصل الدراسي بنجاح']);
        } catch (\Exception) {
            return response()->json(['error' => 'حدث خطأ برجاء المحاولة لاحقا.'], 500);
        }
    }

    public function duplicateSemesterCommittees(Request $request, School $school)
    {
        try {
            $validated = $request->validate([
                'previous_semseter' => 'required|integer|exists:semesters,id',
                'current_semester'  => 'required|integer|exists:semesters,id',
            ]);
    
            $this->committeeService->duplicateSemesterCommittees($school, $validated);
    
            return response()->json(['message' => 'تم تكرار اللجان بنجاح']);
    
        } catch (\Exception $e) {
            return response()->json(['error' => $e->getMessage()], 422);
        }
    }
}
