<?php

namespace App\Http\Controllers\Api\ManagerDashboard\Exams\NamazegPlans;

use App\Http\Controllers\Controller;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\AnswerSheetProgress\StoreAnswerSheetProgressRequest;
use App\Http\Requests\ManagerDashboard\Exams\NamazegPlans\AnswerSheetProgress\UpdateAnswerSheetProgressRequest;
use App\Http\Resources\ManagerDashboard\Exams\NamazegPlans\AnswerSheetProgressResource;
use App\Models\AdminDashboard\School\School;
use App\Models\ManagerDashboard\Exams\NamazegPlans\NamozegAnswerSheetProgress\AnswerSheetProgress;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;

class AnswerSheetProgressController extends Controller
{
    use NamazegTrait;
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request, School $school)
    {
        $queryParams = $request->query();
        $perPage = $queryParams['per_page'] ?? 15;
        $assignment = AnswerSheetProgress::with('namozegVersion','schoolClass')->where('school_id', $school->id)->get();
        $assignment_resource = AnswerSheetProgressResource::collection($assignment);
        return response()->json([
            'data' => $assignment_resource
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAnswerSheetProgressRequest $request,School $school)
    {
        $data = $request->validated();

        try {
            $namozeg = Namazeg::where('form_number', 98)->firstOrFail();
        } catch (ModelNotFoundException $e) {
            return response()->json(['error' => 'Namozeg Not Found for this committee form number in namazeg table .'], 404);
        }

        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school->id
        );

        AnswerSheetProgress::create(
            [
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' => $school->id,
                'schoolClass_id' => $data['schoolClass_id']
            ]
        );

        return response()->json(['message' => trans('api.record stored successflly')]);


    }

    /**
     * Display the specified resource.
     */
    public function show(School $school, AnswerSheetProgress  $assignment)
    {
        $assignment_resource = new AnswerSheetProgressResource($assignment);
        return response()->json([
            'data' => $assignment_resource
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAnswerSheetProgressRequest $request,  School $school, AnswerSheetProgress $assignment)
    {
         $data = $request->validated();

        if ($assignment->school_id !== $school->id) {
            return response()->json(['errors' => trans('لم يتم العثور علي هذا التكليف لهذه المدرسه')], 404);
        }

            $assignment->update(['schoolClass_id' => $data['schoolClass_id']]);

        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(School $school, AnswerSheetProgress $assignment)
    {
        if ($assignment->school_id == $school->id) {
            $assignment->delete();
        }

        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
}
