<?php

namespace App\Http\Controllers\Api\AdminDashboard\TripVideo;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Resources\Video\TripVideoResource;
use App\Http\Requests\Video\StoreTripVideoRequest;
use App\Models\AdminDashboard\TripVideo\TripVideo;
use App\Traits\LogsActivity;

class TripVideoController extends Controller
{
    use LogsActivity;
    /**
     * Display the specified resource.
     */
    public function show(TripVideo $tripVideo)
    {
       $tripVideo =  new TripVideoResource($tripVideo);

        return  response()->json(['tripVideo' => $tripVideo], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(StoreTripVideoRequest $request, TripVideo $tripVideo)

    {
        $data = $request->validated();
        $tripVideo->update($data);
        $this->AdminlogActivity('TripVideo', 'update', '/tripVideo/' . $tripVideo->id);


        return response()->json(['message' => trans('api.record updated successfully')], 200);
    }


}
