<?php

namespace App\Http\Controllers\Api\AdminDashboard\Procedures;

use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\Procedures\StoreAbsenceProceduresFormRequest;
use App\Http\Requests\AdminDashboard\Procedures\UpdateAbsenceProceduresFormRequest;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\Procedures\AbsenceProceduresFormResource;
use App\Models\AdminDashboard\Procedures\AbsenceProcedure\AbsenceProceduresForm;
use Illuminate\Http\Request;

class AbsenceProceduresFormController extends Controller
{
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:AbsenceProceduresForm']);
    }


    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
     
            $absenceProceduresForms = AbsenceProceduresFormResource::collection(AbsenceProceduresForm::paginate($request->per_page));
            
            return response()->json(['absenceProceduresForms' => $absenceProceduresForms, 'message' => trans('api.list of all available records')],200);
       
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAbsenceProceduresFormRequest $request)
    {
      
            $data = $request->validated();

            AbsenceProceduresForm::create($data);

            return response()->json(['message' => trans('api.record stored successflly')],200);
       
    }

    /**
     * Display the specified resource.
     */
    public function getById(AbsenceProceduresForm $absenceProceduresForm)
    {
            $absenceProceduresForm =  new AbsenceProceduresFormResource($absenceProceduresForm);
            return  response()->json(['absenceProceduresForm' => $absenceProceduresForm], 200);
       
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(AbsenceProceduresForm $absenceProceduresForm)
    {
     
            $absenceProceduresForm = new AbsenceProceduresFormResource($absenceProceduresForm);

            return  response()->json(['absenceProceduresForm' => $absenceProceduresForm],200);
       
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAbsenceProceduresFormRequest $request, AbsenceProceduresForm $absenceProceduresForm)
    {
      
            $data = $request->validated();

            $absenceProceduresForm->update($data);

            return response()->json(['message' => trans('api.record updated successflly')], 200);
       
    }

       /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(UpdateStatusRequest $request, AbsenceProceduresForm $absenceProceduresForm)
    {
      
            $absenceProceduresForm->status = $request->status;

            $absenceProceduresForm->save();

            return response()->json(['message' => trans('api.record updated successflly')],200);
        
    }

  /**
     * Soft Delete.
     */
    public function archive(AbsenceProceduresForm $absenceProceduresForm)
    {
       
            $absenceProceduresForm->delete();

            return response()->json(['message' => trans('api.record archived successflly')], 200);
       
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(AbsenceProceduresForm $absenceProceduresForm)
    {
        
            $absenceProceduresForm->forceDelete();

            return response()->json(['message' => trans('api.record deleted successflly')],200);
       
    }

        /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(AbsenceProceduresForm $absenceProceduresForm)
    {
            $absenceProceduresForm->restore();
            return response()->json(['message' => trans('api.record restored successflly')], 200);
       
    }
}
