<?php

namespace App\Http\Controllers\Api\AdminDashboard\Procedures;

use App\Helpers\Helper;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\Procedures\ProcedureNameResource;
use App\Models\AdminDashboard\Procedures\AbsenceProcedure\ProcedureName;
use App\Http\Resources\AdminDashboard\Procedures\AbsenceProcedureResource;
use App\Models\AdminDashboard\Procedures\AbsenceProcedure\AbsenceProcedure;
use App\Http\Requests\AdminDashboard\Procedures\StoreAbsenceProcedureRequest;
use App\Http\Requests\AdminDashboard\Procedures\UpdateAbsenceProcedureRequest;
// use App\Http\Resources\AdminDashboard\Procedures\AbsenceProceduresFormResource;
// use App\Models\AdminDashboard\Procedures\AbsenceProcedure\AbsenceProceduresForm;
use App\Traits\LogsActivity;

class AbsenceProcedureController extends Controller
{
    use LogsActivity;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:absenceProcedures']);
    }

    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
        // Start with the base query
        $data = AbsenceProcedure::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Filter data is directly from query parameters, excluding `per_page`
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\AdminDashboard\Procedures\AbsenceProcedure\AbsenceProcedure', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = AbsenceProcedureResource::collection($data->paginate($perPage));


        return response()->json([
            'absenceProcedures' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }
  
   
    public function procedureNames(Request $request)
    {
          // Start with the base query
          $data = ProcedureName::query();

          // Retrieve all query parameters
          $queryParams = $request->query();
  
          // Filter data is directly from query parameters, excluding `per_page`
          $filterData = array_filter($queryParams, function ($key) {
              return $key !== 'per_page';
          }, ARRAY_FILTER_USE_KEY);
  
          // Apply filters if any
          if (!empty($filterData)) {
              $data = Helper::filterData('App\Models\AdminDashboard\Procedures\AbsenceProcedure\ProcedureName', $filterData);
          }
  
          // Paginate results with a default value if not provided
          $perPage = $queryParams['per_page'] ?? 15;
  
          $filterData = ProcedureNameResource::collection($data->paginate($perPage));
  
  
          return response()->json([
              'ProcedureNames' => $filterData,
              'message' => trans('api.list of all available records'),
          ]);
    }

    /**
     * Show the form for creating a new resource.
     */
    // public function create()
    // {

    //     $absenceProceduresForms = AbsenceProceduresFormResource::collection(AbsenceProceduresForm::all());
    //     return response()->json(['absenceProceduresForms' => $absenceProceduresForms], 200);
    // }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAbsenceProcedureRequest $request)
    {

        // Validate the request and retrieve validated data
        $validatedData = $request->validated();

        // Extract absence_form_id from validated data
        $absence_form_ids = $validatedData['absence_form_id'];
        // Remove absence_form_id from validated data (since it's not a column in AbsenceProcedure)
        unset($validatedData['absence_form_id']);

        // Create AbsenceProcedure
        $absenceProcedure = AbsenceProcedure::create($validatedData);

        // Attach absence_form_ids to the AbsenceProcedure
        $absenceProcedure->absenceForms()->attach($absence_form_ids);
        $this->AdminlogActivity('AbsenceProcedure', 'store', '/procedures/absenceProcedures/' . $absenceProcedure->id . '/details');

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }
    /**
     * Display the specified resource.
     */
    public function getById(AbsenceProcedure $absenceProcedure)
    {
        $absenceProcedure =  new AbsenceProcedureResource($absenceProcedure);

        return  response()->json(['absenceProcedure' => $absenceProcedure], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAbsenceProcedureRequest $request, AbsenceProcedure $absenceProcedure)
    {

        // Update the AbsenceProcedure attributes
        $absenceProcedure->update([
            'name_id' => $request['name_id'],
            'absence_dayes' => $request['absence_dayes'],
            'details' => $request['details'],
         //   'status' => $request['status'],
        ]);

        // Update related AbsenceProceduresForms using sync method
        if (isset($request['absence_form_id'])) {
            $absence_form_ids = $request['absence_form_id'];
            $absenceProcedure->absenceForms()->sync($absence_form_ids);
        }
        $this->AdminlogActivity('AbsenceProcedure', 'update', '/procedures/absenceProcedures/' . $absenceProcedure->id . '/details');


        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(UpdateStatusRequest $request, AbsenceProcedure $absenceProcedure)
    {

        $absenceProcedure->status = $request->status;

        $absenceProcedure->save();

        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /**
     * Soft Delete.
     */
    public function archive(AbsenceProcedure $absenceProcedure)
    {
        $absenceProcedure->delete();
        $this->AdminlogActivity('AbsenceProcedure', 'archive');
        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(AbsenceProcedure $absenceProcedure)
    {

        $absenceProcedure->forceDelete();
        // you might want to detach all related forms
        $absenceProcedure->absenceForms()->detach();
        $this->AdminlogActivity('AbsenceProcedure', 'delete');

        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }


    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(AbsenceProcedure $absenceProcedure)
    {

        $absenceProcedure->restore();
        $this->AdminlogActivity('AbsenceProcedure', 'restore');

        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }
}
