<?php

namespace App\Http\Controllers\Api\AdminDashboard\ExternalSystem;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\ExternalSystem\StoreExternalSystemRequest;
use App\Http\Requests\AdminDashboard\ExternalSystem\UpdateExternalSystemRequest;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\ExternalSystem\ExternalSystemResource;
use App\Models\AdminDashboard\ExternalSystem\ExternalSystem;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

class ExternalSystemController extends Controller
{
    use LogsActivity;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:ExternalSystem']);
    }


    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
        // Start with the base query
        $data = ExternalSystem::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Filter data is directly from query parameters, excluding `per_page`
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\AdminDashboard\ExternalSystem\ExternalSystem', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = ExternalSystemResource::collection($data->paginate($perPage));


        return response()->json([
            'externalSystems' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreExternalSystemRequest $request)
    {
        $data = request()->except('logo');

        $externalSystem =  ExternalSystem::create($data);

        if (request()->hasFile('logo')) {
            $fileName =  Helper::uploadImage('ExternalSystem', request()->file('logo'));
            $externalSystem->logo = $fileName;
            $externalSystem->save();
        }
        $this->AdminlogActivity('ExternalSystem', 'store', '/external-systems/' . $externalSystem->id . '/details');

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Display the specified resource.
     */
    public function getById(ExternalSystem $externalSystem)
    {

        $externalSystem =  new ExternalSystemResource($externalSystem);
        return  response()->json(['externalSystem' => $externalSystem], 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(ExternalSystem $externalSystem)
    {

        $externalSystem  =   new ExternalSystemResource($externalSystem);

        return  response()->json(['externalSystem' => $externalSystem], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateExternalSystemRequest $request, ExternalSystem $externalSystem)
    {
        $data = request()->except('logo');

        $externalSystem->update($data);


        if (request()->hasFile('logo')) {
            $fileName = Helper::uploadImage('ExternalSystem', request()->file('logo'));

            // Delete the existing logo, if it exists
            if ($externalSystem->logo) {
                Helper::removeImage(url('public/uploads/ExternalSystem/' . $externalSystem->logo));
            }
            $externalSystem->logo = $fileName;
            $externalSystem->save();
        }
        $this->AdminlogActivity('ExternalSystem', 'update', '/external-systems/' . $externalSystem->id . '/details');


        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(UpdateStatusRequest $request, ExternalSystem $externalSystem)
    {

        $externalSystem->status = $request->status;
        $externalSystem->save();
        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }
    /**
     * Soft Delete.
     */
    public function archive(ExternalSystem $externalSystem)
    {
        $externalSystem->delete();
        $this->AdminlogActivity('ExternalSystem', 'archive');

        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(ExternalSystem $externalSystem)
    {
        $externalSystem->forceDelete();
        if ($externalSystem->logo) {
            Helper::removeImage(url('public/uploads/ExternalSystem/' . $externalSystem->logo));
        }
        $this->AdminlogActivity('ExternalSystem', 'delete');

        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }


    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(ExternalSystem $externalSystem)
    {
        $externalSystem->restore();
        $this->AdminlogActivity('ExternalSystem', 'restore');

        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }
}
