<?php

namespace App\Http\Controllers\Api\AdminDashboard\EducationalDepartment;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\EducationalDepartment\StoreEducationalDepartmentRequest;
use App\Http\Requests\AdminDashboard\EducationalDepartment\UpdateEducationalDepartmentRequest;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\EducationalDepartment\EducationalDepartmentResource;
use App\Models\AdminDashboard\EducationalDepartment\EducationalDepartment;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;
use Intervention\Image\Colors\Rgb\Channels\Red;

class EducationalDepartmentController extends Controller
{
    use LogsActivity;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:EducationalDepartment']);
    }
   

    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
        // Start with the base query
        $data = EducationalDepartment::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Filter data is directly from query parameters, excluding `per_page`
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\AdminDashboard\EducationalDepartment\EducationalDepartment', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = EducationalDepartmentResource::collection($data->paginate($perPage));


        return response()->json([
            'educationalDepartments' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }


    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreEducationalDepartmentRequest $request)
    {

        $data = $request->validated();

        $EducationalDepartment = EducationalDepartment::create($data);
        $this->AdminlogActivity('EducationalDepartment', 'store', '/educational - department/' . $EducationalDepartment->id . '/details');

        return response()->json(['message' => trans('api.record stored successflly')], 200);
    }

    /**
     * Display the specified resource.
     */
    public function getById(EducationalDepartment $educationalDepartment)
    {

        $educationalDepartment =  new EducationalDepartmentResource($educationalDepartment);

        return  response()->json(['educationalDepartment' => $educationalDepartment], 200);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(EducationalDepartment $educationalDepartment)
    {

        $educationalDepartment = new EducationalDepartmentResource($educationalDepartment);

        return  response()->json(['educationalDepartment' => $educationalDepartment], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateEducationalDepartmentRequest $request, EducationalDepartment $educationalDepartment)
    {

        $data = $request->validated();

        $educationalDepartment->update($data);
        $this->AdminlogActivity('EducationalDepartment', 'store', '/educational - department/' . $educationalDepartment->id . '/details');

        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }
    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(UpdateStatusRequest $request, EducationalDepartment $educationalDepartment)
    {

        $educationalDepartment->status = $request->status;
        $educationalDepartment->save();
        return response()->json(['message' => trans('api.record updated successflly')], 200);
    }

    /**
     * Soft Delete.
     */
    public function archive(EducationalDepartment $educationalDepartment)
    {

        $educationalDepartment->delete();
        $this->AdminlogActivity('EducationalDepartment', 'archive');

        return response()->json(['message' => trans('api.record archived successflly')], 200);
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(EducationalDepartment $educationalDepartment)
    {

        $educationalDepartment->forceDelete();
        $this->AdminlogActivity('EducationalDepartment', 'delete');


        return response()->json(['message' => trans('api.record deleted successflly')], 200);
    }


    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(EducationalDepartment $educationalDepartment)
    {
        $educationalDepartment->restore();
        $this->AdminlogActivity('EducationalDepartment', 'restore');

        return response()->json(['message' => trans('api.record restored successflly')], 200);
    }
}
