<?php

namespace App\Http\Controllers\Api\AdminDashboard\AreasAndCites;

use App\Helpers\Helper;
use App\Http\Controllers\Controller;
use App\Http\Requests\AdminDashboard\AreasAndCities\StoreAreaRequest;
use App\Http\Requests\AdminDashboard\AreasAndCities\UpdateAreaRequest;
use App\Http\Requests\UpdateStatusRequest;
use App\Http\Resources\AdminDashboard\AreasAndCities\AreaResource;
use App\Models\AdminDashboard\AreaAndCities\Area;
use App\Models\AdminDashboard\AreaAndCities\City;
use App\Traits\LogsActivity;
use Illuminate\Http\Request;

class AreaController extends Controller
{
    use LogsActivity;
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:areas-cities']);
    }

    /**
     * Display a listing of the resource.
     */
    public function getAll(Request $request)
    {
        // Start with the base query
        $data = Area::query();

        // Retrieve all query parameters
        $queryParams = $request->query();

        // Filter data is directly from query parameters, excluding `per_page`
        $filterData = array_filter($queryParams, function ($key) {
            return $key !== 'per_page';
        }, ARRAY_FILTER_USE_KEY);

        // Apply filters if any
        if (!empty($filterData)) {
            $data = Helper::filterData('App\Models\AdminDashboard\AreaAndCities\Area', $filterData);
        }

        // Paginate results with a default value if not provided
        $perPage = $queryParams['per_page'] ?? 15;

        $filterData = AreaResource::collection($data->paginate($perPage));


        return response()->json([
            'areas' => $filterData,
            'message' => trans('api.list of all available records'),
        ]);
    }
  

    /**
     * Store a newly created resource in storage.
     */
    public function store(StoreAreaRequest $request)
    {

        
        $data = $request->validated();
        
        $area = Area::create([
            'name' => $data['name'],
          
        ]);
        $this->AdminlogActivity('Area', 'store', '/areas/' . $area->id. '/details/');

        foreach ($data['city'] as $cityName) {
            $city = new City([
                'name' => $cityName,
            ]);
            $area->cities()->save($city);
        }
        return response()->json(['message' => trans('api.record stored successflly')]);
    }

    /**
     * Display the specified resource.
     */
    public function getById(Area $area)
    {
        $area =  new AreaResource($area);
        return  response()->json(['area' => $area], 200);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateAreaRequest $request, Area $area)
    {

        $data = $request->validated();

        // Update the Area attributes
        $area->update([
            'name' => $data['name'],
           
        ]);

        $area->cities()->forceDelete();

        // Update or create City records for the Area
        foreach ($data['city'] as $cityName) {
                $area->cities()->create(['name' => $cityName]); // Associate the city with the area
        }
        $this->AdminlogActivity('Area', 'update', '/areas/' . $area->id . '/details/');
        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /* this method will change activation status for
       specific Model recored by using ID
    */
    public function changeStatus(UpdateStatusRequest $request, Area $area)
    {
        $area->status = $request->status;
        $area->save();
        return response()->json(['message' => trans('api.record updated successflly')]);
    }

    /**
     * Soft Delete.
     */
    public function archive(Area $area)
    {
        $area->delete();
        $area->cities()->delete();
        $this->AdminlogActivity('Area', 'archive');
        return response()->json(['message' => trans('api.record archived successflly')]);
    }
    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Area $area)
    {
        $area->forceDelete();
        $this->AdminlogActivity('Area', 'delete');
        return response()->json(['message' => trans('api.record deleted successflly')]);
    }
    /**
     * restore the specified resource which soft Deleted.
     */
    public function restore(Area $area)
    {
        $area->restore();
        $area->cities()->restore();
        $this->AdminlogActivity('Area', 'restore');
        return response()->json(['message' => trans('api.record restored successflly')]);
    }
}
