<?php

namespace App\Http\Controllers\Api\AdminDashboard;

use App\Http\Controllers\Controller;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class AdminHomeController extends Controller
{
    /* to uses the class methods
        -you should be authenticated
        -you should be authorized and have this permission
    */
    public function __construct()
    {
        //$this->middleware(['auth:api','permission:admin-home-statistics']);
    }

    public function getStatistics()
    {
        $clients = User::where('user_type', 'school_manager')->count();

        $orders = 0;
        $revenues = 0;
        $profits = 0;

        $data = [
            'clients' => $clients,
            'orders' => $orders,
            'revenues' => $revenues,
            'profits' => $profits,
        ];

        return response()->json(['statistics' => $data, 'message' => trans('api.admin home statistics')]);
    }

    public function getSubscriptionsMonthlyCountPerYear(Request $request)
    {
        // Set the locale to Arabic for month names
        Carbon::setLocale('ar');

        $year = $request->year ?? Carbon::now()->format('Y');

        // Query the database for the subscriptions count
        $results = Subscription::select(
            DB::raw('MONTH(created_at) as month'),
            DB::raw('COUNT(*) as count')
        )
            ->whereYear('created_at', $year)
            ->where('service_type', 'system')
            ->whereIn('status', ['Subscribed', 'Experimental'])
            ->groupBy('month')
            ->orderBy('month', 'asc')
            ->get();

        // Initialize an array for all months with a default count of 0
        $monthlyCounts = [];
        for ($month = 1; $month <= 12; $month++) {
            $monthName = Carbon::createFromDate($year, $month, 1)->translatedFormat('F');
            $monthlyCounts[$monthName] = 0;
        }

        // Populate the months with actual counts from the results
        foreach ($results as $result) {
            $monthName = Carbon::createFromDate($year, $result->month, 1)->translatedFormat('F');
            $monthlyCounts[$monthName] = $result->count;
        }

        return response()->json([
            'subscriptionsMonthlyCounts' => $monthlyCounts,
            'message' => trans('api.subscriptions count for each month of specific year')
        ]);
    }

    public function latestSubscriptions()
    {
        $latestSubscriptions = Subscription::where('paid_type','!=',value: null)->latest()->take(3)->get();
        $data = $latestSubscriptions->map(function ($subscription) {
            return [
                'id' => $subscription->id,
                'order_number' => $subscription->order_number,
                'invoice_number' => $subscription->user?->name,
                'total_price' => $subscription->total_price,
            ];
        });

        return response(['data' => $data]);
    }
}
