<?php

namespace App\Helpers;

use App\Jobs\SendSMSNotification;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\AbsenseAndLateness\StudentAbsenceProcedure;
use App\Models\ManagerDashboard\Exams\StudentCommittees\StudentCommittee;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlane;
use App\Models\ManagerDashboard\NotificationSettings\NotificationSchoolSetting;
use App\Models\ManagerDashboard\Settings\Subscription;
use App\Models\ManagerDashboard\Tables\WaitingPeriodsSchedule\WaitingPeriodsSchedule;
use App\Models\ManagerDashboard\Tasks\Task;
use App\Models\ManagerDashboard\TeacherScheduleData;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Meeting;
use App\Models\ManagerDashboard\Violations\ViolationStudent;
use App\Models\Notification;
use App\Models\User;
use App\Traits\NotificationTrait;
use App\Traits\SmsTrait;
use Carbon\Carbon;
use Tymon\JWTAuth\Facades\JWTAuth;

class HelperNotification
{
    use NotificationTrait, SmsTrait;

    protected $user, $today;
    public function __construct($user = null)
    {
        $this->user =  $user ?? JWTAuth::parseToken()->authenticate();
        $this->today = Carbon::now()->format('d/m/Y');
    }
    protected $notification_enum = [
        1 => 'تذكير خطة المدير',
        2 => 'تذكيره بمهام اليوم',
        3 => 'الاشتارك فى النظام',
        4 => 'اشتركك على وشك الانتهاء جدد اشتراكك للاستمرار فى استخدام جميع مميزات النظام',
        5 => 'ادخال تخصص المعلمين',
        6 => 'تنبيه بنموذج خطة مدير لاسبوع قادم لم توضع بعد',
        7 => 'قرب انتهاء الرصيد',
        8 => 'يرجى تعبئة نموذج المسائلة الخاص بالمعلم واتخاذ الاجراء اللازم',
        9 => 'تأمين حصص للمعلم الغائب',
        10 => 'الغاء حصص الانتظار',
        11 => 'اجتماع اللجنه غدا',
        12 => 'الاجتماع غير مكتمل',
        13 => 'لم يتم استكمال بيانات التكليف',
        14 => 'انشاء بيان اطلاع الموظفين على التعميم',
        15 => 'انشاء بيان اطلاع المعلمين على التعميم',
        16 => 'زيارات صفية متبادلة',
        17 => 'انشاء جداول الاختبارات',
        18 => 'موعد الزيارة الصفية اليوم',
        19 => 'انشاء خطط الزيارات الصفية ',
        20 => 'يوجد لديك لجان غير مكتملة فى قسم لجان الاختبارات وقد يؤثر ذلك على عملية سير الاختبارات',
        21 => 'انشاء لجان الاختبارات للطلاب',
        22 => 'اجراءات مطلوبة فى المواظبة',
        23 => 'اجراء سلوكى غير مكتمل',
        24 => 'انشاء نموذج الالتزام المدرسى',
        25 => 'لم يتم تفعيل الايميل',
    ];

    public  function manager_notifications($school_id = null)
    {
        $school_id = $school_id ?? $this->user->employee?->school_id;
        // الرئيسية 1
        // تذكير خطة المدير
        $current_semester = Helper::getCurrentSchoolSemester();
        if ($current_semester) {
            $semesterWeekDay = SemesterWeekDay::where('date', $this->today)->first();
            $manger_plan = NamazegManagerPlane::where('status', 'notdone')
                ->where('school_id', $school_id)
                ->where('semester_id', $current_semester->id)
                ->where('week_id', $semesterWeekDay?->week_id)
                ->whereNotNull('week_id')
                ->first();

            if ($manger_plan && in_array($semesterWeekDay->day_id,[1,5])) {
                static::CreateWebsiteNotification(
                    1,
                    'لم يتم انشاء الخطة الأسبوعية',
                    'لم يتم انشاء الخطة لهذا الاسبوع, يرجى اعداد الخطة الاسبوعية مع اهمية التقيد بها.',
                    $school_id,
                    [$this->user->id],
                    'bell',
                    'NamazegManagerPlane',
                    131, // رقم النموذج
                );
            }

            // // تذكيره بمهام اليوم
            $yesterday = now()->subDay()->format('d/m/Y');
            $count_tasks = Task::where('date', $yesterday)->where('achieved', 0)->where('type','task')->count();
            if ($count_tasks > 0) {
                static::CreateWebsiteNotification(
                    2,
                    'مهام غير مكتملة',
                    'لديك مهام لم تنتهى منها فى الايام الماضية, يرجى مراجعتها واستكمالها',
                    $school_id,
                    [$this->user->id],
                    'bell',
                );
            }

            // الاشتارك فى النظام  ----------------------------------------------------

            $subscribtions = Subscription::where('user_id', $this->user->id)
                ->where('service_type', 'system')->get();
            if (count($subscribtions) == 1 || count($subscribtions) == 0) {
                static::CreateWebsiteNotification(
                    3,
                    'اشترك الان واحصل على وصول كامل لنظام لام',
                    'اشترك الان واحصل على وصول كامل لنظام لام',
                    $school_id,
                    [$this->user->id],
                    'priority_tape'
                );
            }

            $subscribtion = $subscribtions->where('paid_status', 'paid')
                ->where('status', 'subscribed')
                ->sortByDesc('id')->first();

            $expire_date = now()->addDays(14)->format('d/m/Y');
            if ($subscribtion && Carbon::createFromFormat('d/m/Y', $subscribtion->end_date)->lessThanOrEqualTo(Carbon::createFromFormat('d/m/Y', $expire_date))) {
                static::CreateWebsiteNotification(
                    4,
                    'اشتركك على وشك الانتهاء جدد اشتراكك للاستمرار فى استخدام جميع مميزات النظام',
                    'اشتركك على وشك الانتهاء جدد اشتراكك للاستمرار فى استخدام جميع مميزات النظام',
                    $school_id,
                    [$this->user->id],
                    'priority_tape'
                );
            }


            //المدرسة 2
            //ادخال تخصص المعلمين
            $count_school_employees = SchoolEmployee::where('school_id', $school_id)->where('specialization_id', null)->count();
            if ($count_school_employees > 0) {
                static::CreateWebsiteNotification(
                    5,
                    'يرجى ادخال تخصص المعلمين',
                    'بعض الاقسام مقيدة حاليا, يرجى ادخال تخصص المعلمين.',
                    $school_id,
                    [$this->user->id],
                    'normal_tape'
                );
            }

            // تنبيه بنموذج خطة مدير لاسبوع قادم لم توضع بعد
            // $date_next_week = Carbon::today()->addWeek()->format('d/m/Y');
            $date_next_week = Carbon::today()->addDays(4)->format('d/m/Y');
            $semesterWeekDay = SemesterWeekDay::where('date', $date_next_week)->first();
            $manger_plan = NamazegManagerPlane::doesntHave('plane_details')
            ->where('school_id', $school_id)
            ->where('semester_id', $current_semester?->id)
            ->whereNotNull('week_id')
            ->where('week_id', $semesterWeekDay?->week_id)
            ->where('status', 'notdone')
            ->first();
            if ($manger_plan && in_array($semesterWeekDay->day_id, [1, 5])) {
                static::CreateWebsiteNotification(
                    6,
                    "لم يتم إنشاء خطة المدير الاسبوعية",
                    'يجب اعداد خطتك الاسبوعية ' . ' - ' . $manger_plan->week_name,
                    $school_id,
                    [$this->user->id],
                    'normal_tape',
                    'NamazegManagerPlane',
                    131, // رقم النموذج
                );
            }


            // تنبيه بأن الباقى من الباقة 15 % 
            $subscription = Subscription::with('product')
                ->where('user_id', $this->user->id)
                ->where('service_type', 'sms')
                ->whereIn('status', ['subscribed', 'Experimental'])
                ->where('paid_status', 'paid')
                ->first();
            if ($subscription) {
                $rest_package = ($subscription->product->messages_count - $subscription->messages_consumed) / $subscription->product->messages_count * 100;  // mean 15 %
                if ($rest_package <= 15) {
                    static::CreateWebsiteNotification(
                        7,
                        'قرب انتهاء الرصيد',
                        'رصيدك المتبقى قارب على الانتهاء يرجى تجديد الرصيد قريبا لضمان استمرار الخدمة دون انقطاع ',
                        $school_id,
                        [$this->user->id],
                        'normal_tape'
                    );
                }
            }
        }
    }


    // sent notification to manager and supervisor 8 work id مساءلة عند تأخر املعلم
    // i use it in SchoolEmployeeAttendanceController
    public static function create_employee_late_notifications($school_id, $employees_id, $type = "absent")
    {
        $questioning_type = $type == "absent" ? "غياب" : 'تأخر';
        $model = $type == "absent" ? "NamazegAbsenceQuestioning" : 'NamazegMonitoringLateAbsenceTeacher';
        $form_number = $type == "absent" ? '169' : '177';
        $employee = SchoolEmployee::where('id', $employees_id)->first();
        $users_id = SchoolEmployee::where('school_id', $school_id)->whereIn('current_work_id', [1, 8])->pluck('user_id')->toArray();
        $users_id = array_filter($users_id, function ($user_id) {
            return !is_null($user_id);
        });
        static::CreateWebsiteNotification(
            8,
            '  اجراء تنبيه عن   '.' '.$questioning_type.' :  '.$employee->name,
            'يرجى تعبئة نموذج المسائلة الخاص بالمعلم واتخاذ الاجراء اللازم',
            $school_id,
            $users_id,
            'bell',
            $model,
            $form_number, // رقم النموذج
            $employees_id
        );
    }

    // sent notification to supervisor 8 work id ني حصص االنتظار
    // i use it in SchoolEmployeeAttendanceController
    public static function create_waiting_periods_notifications($school_id, $employees_id, $type)
    {
        $today = Carbon::now()->format('d/m/Y');
        // notification sender
        //تأمين حصص غياب المعلمات
        $notification_setting = NotificationSchoolSetting::where('school_id', $school_id)
            ->where('notification_setting_id', 1)
            ->first();
        $teacher = SchoolEmployee::where('id', $employees_id)->first();
        $users_id = SchoolEmployee::where('school_id', $school_id)->where('current_work_id', 8)->pluck('user_id')->toArray();
        // تأمين  الحصص عند غياب المعلم 
        if ($type == "absent") {
            //)لوكيل الشؤون التعليمية(
            $day_data = SemesterWeekDay::where('date', $today)->first();
            $teacher_check = TeacherScheduleData::with('teacher_schedual')
                ->where('day_id', $day_data->day_id)
                ->whereHas('employee', function ($query) use ($teacher) {
                    $query->where('id', $teacher->id);
                })
                ->whereHas('teacher_schedual', function ($query) use ($day_data) {
                    $query->where('semester_id', $day_data->semester_id);
                })
                ->first();
            if ($teacher_check && $notification_setting->website) {
                static::CreateWebsiteNotification(
                    9,
                    ' تأمين حصص للمعلم الغائب',
                    'يرجى تأمين حصص المعلم الغائب لضمان استمرارية سير العملية التعليمية',
                    $school_id,
                    $users_id,
                    'bell',
                    'WaitingPeriodsSchedule',
                    51, // رقم النموذج
                    $teacher->id
                );
            }
            if ($teacher_check && $notification_setting->messages) {
                $message_text = "تم تسجيل غياب للمعلم" . ' [ ' . $teacher->name . ' ] ' . ' : يرجى اتخاذ التجدبيرات اللازمه لتأمين حصصه اليوم.';
                $users = User::whereIn('id', $users_id)->get();
                foreach ($users as $user) {
                    static::sendSMSNotification($user->phone, $message_text, $user->manager_id);
                }
            }
        } elseif ($type == "attended") {
            //حذف تأمين حصص الانتظار عند حضور المعلمة
            $notification_setting = NotificationSchoolSetting::where('school_id', $school_id)->where('notification_setting_id', 18)->first();
            $schedual_check = WaitingPeriodsSchedule::where('creation_date', $today)->where('school_id', $school_id)
                ->where('school_employee_id', $employees_id)->first();
            if ($schedual_check && $notification_setting->website) {
                static::CreateWebsiteNotification(
                    10,
                    'الغاء حصص الانتظار',
                    'حضور المعلم متأخر يرجى تعديل حالة تأمين حصص الانتظار للمعلم ' . $teacher->name . ' بسبب حضوره . يرجى تحديث االجداول وفقا للوضع الحالى',
                    $school_id,
                    $users_id,
                    'bell',
                    'WaitingPeriodsSchedule',
                    51, // رقم النموذج
                    $teacher->id
                );
            }
            if ($schedual_check && $notification_setting->messages) {
                $message_text = "يرجى تعديل تأمين حصص الانتظار للمعلم " . ' [ ' . $teacher->name . ' ] ' . ' بعد حضور المعلم المتأخر.';
                $users = User::whereIn('id', $users_id)->get();
                foreach ($users as $user) {
                    static::sendSMSNotification($user->phone, $message_text, $user->manager_id);
                }
            }
        }
    }


    // Meetings  عند قرب موعد الاجتماع
    // In AssignmentCommitteeController
    public static function create_soon_meetings_notifications($school_id, $meeting)
    {
        $member = $meeting->members->where('assignment_work', 'رئيساً للفريق');
        if (count($member) > 0) {
            $team_manager = $member[0];
            $committe = $meeting->committe;
            $school_employee = SchoolEmployee::where('id', $team_manager->employee_id)->first();
            // تنبيهات الاجتماعات
            $notification_setting = NotificationSchoolSetting::where('school_id', $school_id)->where('notification_setting_id', 3)->first();
            if ($notification_setting->website) {
                $date = Carbon::createFromFormat('d/m/Y', $meeting->date)->addDay()->format('d/m/Y');
                static::CreateWebsiteNotification(
                    11,
                    'اجتماع اللجنه غدا',
                    'يرجى التأكد من تحضير جميع المتطلبات للاجتماع',
                    $school_id,
                    [$school_employee->user_id],
                    'bell',
                    'AssignmentCommitteeMeeting',
                    $committe->form_number, // رقم النموذج
                    $committe->id,
                    $date
                );
            }
            if ($notification_setting->messages) {
                $message_text = "غدا موعد اجتماع لجنة" . ' [ ' . $meeting->name . ' ] ' . ' , يرجى التحقق من جدول الاعمال والاستعداد للحضور.';
                foreach ($meeting->members as $member) {
                    $user = $member->employee;
                    static::sendSMSNotification($user->phone, $message_text, $user->manager_id);
                }
            }
        }
    }
    // الاجتماع غير مكتمل ومر 24 ساعة على تاريخ الاجتماع
    public function create_not_complete_meetings_notifications($school_id = null)
    {
        $user = $this->user;
        $yesterday = Carbon::yesterday()->format('d/m/Y');
        $notification_setting = NotificationSchoolSetting::where('school_id', $school_id)
            ->where('notification_setting_id', 3)->first();
        if ($notification_setting) {
            if ($notification_setting->website) {
                $meetings = Meeting::with('members', 'committe')->where('date', $yesterday)
                    ->where('model_type', 'committees')
                    ->where('meeting_status', 'not_completed')
                    ->get();
                if (count($meetings) > 0) {
                    foreach ($meetings as $meeting) {
                        $members = $meeting->members->where('employee_id', $user->id)->where('assignment_work', 'رئيساً للفريق');
                        if (count($members) > 0) {
                            static::CreateWebsiteNotification(
                                12,
                                'الاجتماع غير مكتمل',
                                'مرت 24 ساعه على موعد الاجتماع, ولم يتم اكمال الاجراءات المطلوبة الخاصه بالاجتماع',
                                $school_id,
                                [$user->id],
                                'bell',
                                'AssignmentCommitteeMeeting',
                                $meeting->committe->form_number, // رقم النموذج
                                $meeting->committe->id
                            );
                        }
                    }
                }
            }
        }
    }


    // عند انشاء تكليف معلمين ليس لديهم تخصص
    // In AssignmentController
    public static function create_teacher_assignment_notifications($staffAssignment, $specialest_employee)
    {
        $school_employee_name = $specialest_employee->name;
        $school_id = $specialest_employee->school_id;
        $users_id = SchoolEmployee::where('school_id', $school_id)->whereIn('current_work_id', [1, 8])->pluck('user_id')->toArray();
        $users_id = array_filter($users_id, function ($user_id) {
            return !is_null($user_id);
        });
        $check_exist = Notification::where('model_id', $specialest_employee->currentWork->assignment_form_number)->where('data_id', $staffAssignment->id)->first();
        if (!$check_exist) {
            static::CreateWebsiteNotification(
                13,
                'لم يتم استكمال بيانات التكليف',
                'لم يتم اكمال التخصصات الخاصه بالمعلمين او استيراد بيانات المعلمين بالكامل. يرجى استكمال البيانات لضمان اعداد التكليفات بشكل صحيح',
                $school_id,
                $users_id,
                'normal_tape',
                'Assignment',
                $specialest_employee->currentWork->assignment_form_number, // رقم النموذج
                $staffAssignment->id
            );
        }
    }

    // عند انشاء تعميم 
    // In Circulars
    public static function create_Circulars_notifications($school_id)
    {
        $user =  JWTAuth::parseToken()->authenticate();
        static::CreateWebsiteNotification(
            14,
            'انشاء بيان اطلاع الموظفين على التعميم',
            'قم بانشاء نموذج اطلاع الموظفين على التعميم لضمان علم الجميع بمحتوى التعميم والتوجيهات الواردة فيه.',
            $school_id,
            [$user->id],
            'bell',
            'NamazegCircularAttendance',
            129, // رقم النموذج
        );
    }

    // عند انشاء تعميم 
    // In LetterController - warning
    public static function create_warning_letter_notifications($school_id)
    {
        $user =  JWTAuth::parseToken()->authenticate();
        static::CreateWebsiteNotification(
            15,
            'انشاء بيان اطلاع المعلمين على التعميم',
            'قم بانشاء نموذج اطلاع المعلمين على التعميم لضمان علم الجميع بمحتوى التعميم والتوجيهات الواردة فيه.',
            $school_id,
            [$user->id],
            'bell',
            'NamazegCircularAttendanceNew',
            225, // رقم النموذج
        );
    }
    // الزيارات الصفية المتبادلة
    // In tables class room vistis
    public static function create_class_room_visit_notifications($school_id, $classRoomVisit)
    {
        $user =  JWTAuth::parseToken()->authenticate();
        // جداول وكيل الشئون التعليمية
        $notification_setting = NotificationSchoolSetting::where('school_id', $school_id)->where('notification_setting_id', 2)->first();
        // تنبيهات الزيارات الصفية المتبادلة
        $notification_setting_visits = NotificationSchoolSetting::where('school_id', $school_id)->where('notification_setting_id', 8)->first();
        $users = SchoolEmployee::where('school_id', $school_id)->where('current_work_id', 6)->get();
        if ($notification_setting->website && $notification_setting_visits->website) {
            $users_id = $users->pluck('user_id')->toArray();
            // وكيل الشئون التعليمية
            static::CreateWebsiteNotification(
                16,
                'زيارات صفية متبادلة',
                'يوجد زيارات صفية متبادلة اليوم بين المعلمين. يرجى متابعة الزيارة لضمان تحقيق الاهداف التعليميةالمطلوبة',
                $school_id,
                $users_id,
                'bell',
            );
        }
        // رسالة الى الزائر والمزور فى نفس اليوم
        if ($notification_setting->messages && $notification_setting_visits->messages) {
            $message_text = "لديك زيارة صفية مجدولة اليوم . نرجو الالتزام بالتوقيت المحدد.";
            $visitedTeacher = $classRoomVisit->visitedTeacher;
            $visitingTeacher = $classRoomVisit->visitingTeacher;
            $sendAt = Carbon::createFromFormat('d/m/Y', $classRoomVisit->date)->setTime(5, 0, 0);
            SendSMSNotification::dispatch($visitedTeacher->phone, $message_text, $user->manager_id)->delay($sendAt);
            SendSMSNotification::dispatch($visitingTeacher->phone, $message_text, $user->manager_id)->delay($sendAt);
        }
    }

    // انشاء جدول اختبارات
    // In loginController week 5 and week 11 
    public function create_exame_notifications($school_id = null)
    {
        $user = $this->user;
        $today = Carbon::now()->format('d/m/Y');
        $week_day = SemesterWeekDay::where('date', $today)->where('day_id', 1)->whereIn('week_id', [5, 11])->first();
        if ($week_day) {
            // تنبيهات إنشاء جداول الاختبارات الفترية
            $notification_setting_middle = NotificationSchoolSetting::where('school_id', $school_id)
                ->where('notification_setting_id', 9)->first();
            // تنبيهات إنشاء جداول الاختبارات النهائية
            $notification_setting_last = NotificationSchoolSetting::where('school_id', $school_id)
                ->where('notification_setting_id', 10)->first();

            if (($notification_setting_middle->website && $week_day->week_id == 5) || ($notification_setting_last->website && $week_day->week_id == 11)) {
                $exame_name = $week_day->week_id == 5 ? 'الفترية' : 'النهائية';
                $message = $week_day->week_id == 5 ? 'يرجى البدء بانشاء جداول الاختبارات الفترية للاسبوع الخامس من الفصل الدراسى الحالى لضمان تنظيم الاختبارات وفق الجدول الزمنى' : 'يرجى البدء بانشاء جداول الاختبارات النهائية للاسبوع الحادى عشر بما يشمل المواد ذات الجانبين والاختبارات التحريرية, لضمان تنظيم الاختبارات وفق الدول الزمنى';
                // وكيل شئون التعليمية
                $users_id = SchoolEmployee::where('school_id', $school_id)->whereIn('current_work_id', [6, 1])->pluck('user_id')->toArray();
                static::CreateWebsiteNotification(
                    17,
                    ' انشاء جداول الاختبارات' . ' ' . $exame_name,
                    $message,
                    $school_id,
                    $users_id,
                    'bell',
                    'Exame'
                );
            }
        }
    }
    // In ClassRoomVisitController
    //زيارى صفيه اليوم 
    public static function create_class_visits_notifications($classRoomVisit)
    {
        $user =  JWTAuth::parseToken()->authenticate();
        $school_id = $classRoomVisit->school_id;
        // تنبيهات الزيارات الصفية للمعلم
        $notification_setting_visits_teacher = NotificationSchoolSetting::where('school_id', $school_id)->where('notification_setting_id', 11)->first();

        $users_id = SchoolEmployee::where('school_id', $school_id)->whereIn('current_work_id', [1, 8])->pluck('user_id')->toArray();
        static::CreateWebsiteNotification(
            18,
            'موعد الزيارة الصفية اليوم',
            'لديك زيارة صفية مجدولة اليوم يرجى لاستعداد للحضور فى لوقت المحدد والمتابعة لضمان تحقيق الاهداف التعليمية',
            $school_id,
            $users_id,
            'bell',
            'ClassRoomVisitSession',
            202,
            $classRoomVisit->id,
            $classRoomVisit->date
        );
        // موعد زيارة صفية للمعلم
        if ($notification_setting_visits_teacher->messages) {
            $message_text = "لديك زيارة صفية مجدولة اليوم . نرجو التواجد فى الوقت المحدد.";
            $visitedTeacher = $classRoomVisit->teacher;
            $sendAt = Carbon::createFromFormat('d/m/Y', $classRoomVisit->date)->setTime(5, 0, 0);
            SendSMSNotification::dispatch($visitedTeacher->phone, $message_text, $user->manager_id)->delay($sendAt);
        }
    }

    // انشاء زيارات صفية فى بداية كل فصل دراسى
    //  IN AuthController week 1 day 1  
    public function create_class_room_visits_notifications($school_id = null)
    {
        $today = Carbon::now()->format('d/m/Y');
        $user = JWTAuth::parseToken()->authenticate();
        $week_day = SemesterWeekDay::where('date', $today)->where('day_id', 1)->where('week_id', 1)->first();
        if ($week_day) {
            static::CreateWebsiteNotification(
                19,
                'انشاء خطط الزيارات الصفية ',
                'يرجى اعداد خطط الزيارات الصفية وتنظيم جدول الزيارات لضمان متابعة العملية التعليمية',
                $school_id,
                [$user->id],
                'bell',
                'ClassRoomVisitSession',
                202
            );
        }
    }


    // لجان الاختبارات غير مكتملة
    //  IN AuthController 
    public function create_uncomplete_exame_committe_notifications($school_id = null)
    {
        $user = $this->user;
        $date = Carbon::now()->subDay();
        $exame_committe_count = StudentCommittee::where('school_id', $school_id)
            ->where('schoolclass_id', null)
            ->doesntHave('CommitteeData')
            ->whereDate('created_at', '<=', $date)
            ->count();

        if ($exame_committe_count > 0) {
            static::CreateWebsiteNotification(
                20,
                'يوجد لديك لجان غير مكتملة فى قسم لجان الاختبارات وقد يؤثر ذلك على عملية سير الاختبارات',
                'يوجد لديك لجان غير مكتملة فى قسم لجان الاختبارات وقد يؤثر ذلك على عملية سير الاختبارات',
                $school_id,
                [$user->id],
                'normal_tape',
                'Exame',
                61
            );
        }
    }
    // اشعار انشاء لجان اختبارات فى الاسبوع 11
    //  IN AuthController 
    public function create_create_exame_committe_notifications($school_id)
    {
        $user = $this->user;
        // week 11 
        $semesterWeekDay = SemesterWeekDay::where('date', $this->today)
            ->where('week_id', 11)->first();
        if ($semesterWeekDay) {

            $date = Carbon::now();
            $exame_committe_count = StudentCommittee::where('school_id', $school_id)
                ->where('semester_id', $semesterWeekDay->semester_id)
                ->count();
            if ($exame_committe_count == 0) {
                static::CreateWebsiteNotification(
                    21,
                    'انشاء لجان الاختبارات للطلاب',
                    'يرجى انشاء لجان الاختبارات للطلاب قبل بدء الاختبارات النهائية باسبوع لتنظيم عملية سير الاختبارات',
                    $school_id,
                    [$user->id],
                    'bell',
                    'Exame',
                    61
                );
            }
        }
    }

    // لو فى اجراء مهم فى المواظبة
    //  IN AuthController 
    public function create_absence_actions_needed_notifications($school_id = null)
    {
        $user = $this->user;

        $absence_actions_required = StudentAbsenceProcedure::where('warning', '!=', null)
            ->where('school_id', $school_id)
            ->get();

        if (count($absence_actions_required) != 0) {
            foreach ($absence_actions_required as $absence_action) {
                static::CreateWebsiteNotification(
                    22,
                    'اجراءات مطلوبة فى المواظبة',
                    'يوجد اجراءات فى قسم المواظبة تتطلب اتخاذ بعض الخطوات يرجى مراجعة التفاصيل واتخاذ لاجراء اللازم',
                    $school_id,
                    [$user->id],
                    'bell',
                    'StudentAbsenceProcedure',
                    $absence_action->id
                );
            }
        }
    }
    // لو فى اجراء مهم فى السلوك
    //  IN AuthController 
    public function create_vioaltions_actions_needed_notifications($school_id = null)
    {
        $user = $this->user;
        $violations_count = ViolationStudent::with('violation_titles')
            ->where('published',1)
            ->whereHas('violation_titles', function ($violation_title) {
                $violation_title->where('status', 'started');
            })
            ->where('school_id', $school_id)->count();
        if ($violations_count != 0) {
            static::CreateWebsiteNotification(
                23,
                'اجراء سلوكى غير مكتمل',
                'يرجى مراجعة التفاصيل واتخاذ الخطوات اللازمة لاستكمال الاجراء',
                $school_id,
                [$user->id],
                'bell',
                'Violations',
                108
            );
        }
    }

    // تنبيه بانشاء النموذج بعد استيراد بيانات الطلاب
    //  IN Register 
    public function create_namazegSchoolCommitment_notifications()
    {
        $user = $this->user;
        $schools = SchoolEmployee::where('user_id', $user->id)->get();
        foreach ($schools as $school) {
            $school_id = $school->school_id;
            static::CreateWebsiteNotification(
                24,
                'انشاء نموذج الالتزام المدرسى',
                'يرجى انشاء نموذج الالتزام المدرسى لجميع الطلاب',
                $school_id,
                [$user->id],
                'bell',
                'NamazegSchoolCommitment',
                144
            );
        }
    }
    // تنبيه تفعيل الايميل الالكترونى
    //  IN HomeController
    public function is_email_verified($school_id)
    {
        $user = $this->user;
        static::CreateWebsiteNotification(
            25,
            'يرجى التحقق من بريدك الالكترونى لتوثيق حسابك.',
            'يرجى التحقق من بريدك الالكترونى لتوثيق حسابك.',
            $school_id,
            [$user->id],
            'priority_tape',
            'EmailVerification',
            5555
        );
    }
}
