<?php

namespace App\Helpers;

use App\Models\Week;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use Alkoumi\LaravelHijriDate\Hijri;
use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolClass;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\AdminDashboard\School\SchoolSemester;
use App\Models\AdminDashboard\School\SemesterWeekDay;
use App\Models\ManagerDashboard\Assignments\Assignment;
use App\Models\ManagerDashboard\Assignments\AssignmentEmployee;
use App\Models\ManagerDashboard\Namazeg\NamazegManagerPlane;
use App\Models\ManagerDashboard\Namazeg\NamazegVersion;
use App\Models\ManagerDashboard\NotificationSettings\NotificationSchoolSetting;
use App\Models\ManagerDashboard\NotificationSettings\NotificationSetting;
use App\Models\ManagerDashboard\SupervisionSchedul;
use App\Models\ManagerDashboard\Tables\ShiftSchedule\ShiftSchedule;
use App\Models\ManagerDashboard\TeacherSchedule;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Schema;

class Helper
{
    use NamazegTrait;
    public static function uploadedFilesPath($model, $file)
    {
        return url("public/uploads/$model/files/$file");
    }

    public static function uploadedImagesPath($model, $image)
    {
        return url('public/uploads/' . $model . '/' . $image, false);
    }

    public static function flattenArray(array $array): array
    {
        $result = [];

        foreach ($array as $value) {
            if (is_array($value)) {
                // Recursively flatten the array
                $result = array_merge($result, Helper::flattenArray($value));
            } else {
                // Add the class directly if it's not an array
                $result[] = $value;
            }
        }

        return $result;
    }


    public static function uploadImage($model, $image)
    {
        if ($image) {
            $extension = pathinfo($image->getClientOriginalName(), PATHINFO_EXTENSION);
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing image

            $path = public_path("uploads/$model/");
            if (!File::exists($path)) {
                File::makeDirectory($path, 0755, true); // true allows recursive creation
            }

            $manager = new ImageManager(new Driver());

            $image = $manager->read($image);

            $image->save($path . $fileName);

            return  $fileName;
        } else {
            return NULL;
        }
    }

    public static function removeImage($imagePath)
    {
        if (file_exists($imagePath)) {
            unlink($imagePath);
        }
    }

    public static function updateUploadedImage($model, $image, $oldImage)
    {
        if ($image) {
            // Remove the old image
            $oldImagePath = url("uploads/$model/$oldImage");
            if ($oldImage && file_exists($oldImagePath)) {
                unlink($oldImagePath);
            }
            $extension = pathinfo($image->getClientOriginalName(), PATHINFO_EXTENSION);
            $fileName = rand(11111, 99999) . '.' . $extension; // renaming image
            $path = public_path("uploads/$model/$fileName");
            $manager = new ImageManager(new Driver());
            $image = $manager->read($image);
            $image->save($path);
            return $fileName;
        } else {
            return null;
        }
    }

    public static function uploadFile($model, $file)
    {
        if ($file) {
            $size = round($file->getSize() / (1024 * 1024), 2);
            $extension = pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION);
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing file
            $path = public_path("uploads/$model/files/");
            $file->move($path, $fileName);
            return ['file_name' => $fileName, 'file_size' => $size];
        } else {
            return NULL;
        }
    }

    public static function updateUploadFile($model, $file, $oldFile)
    {
        if ($file) {
            ///////remove the old image///////

            $oldFile ? $oldFile = $path = public_path() . "/uploads/$model/files/" . $oldFile : $oldFile = null;
            if (file_exists($oldFile)) {
                unlink($oldFile);
            }
            $size = round($file->getSize() / (1024 * 1024), 2);
            $extension = pathinfo($file->getClientOriginalName(), PATHINFO_EXTENSION);
            $fileName = rand(11111, 99999) . '.' . $extension; // renameing file
            $path = public_path("uploads/$model/files/");
            $file->move($path, $fileName);
            return ['file_name' => $fileName, 'file_size' => $size];
        } else {
            return NULL;
        }
    }



    public static function numberToWord($number, $lang = 'ar')
    {
        $words = [
            'ar' => [
                'ones' => [
                    1 => 'الأول',
                    2 => 'الثاني',
                    3 => 'الثالث',
                    4 => 'الرابع',
                    5 => 'الخامس',
                    6 => 'السادس',
                    7 => 'السابع',
                    8 => 'الثامن',
                    9 => 'التاسع',
                    10 => 'العاشر'
                ],
                'teens' => [
                    11 => 'الحادي عشر',
                    12 => 'الثاني عشر',
                    13 => 'الثالث عشر',
                    14 => 'الرابع عشر',
                    15 => 'الخامس عشر',
                    16 => 'السادس عشر',
                    17 => 'السابع عشر',
                    18 => 'الثامن عشر',
                    19 => 'التاسع عشر'
                ],
                'tens' => [
                    20 => 'العشرون',
                    30 => 'الثلاثون',
                    40 => 'الأربعون',
                    50 => 'الخمسون',
                    60 => 'الستون',
                    70 => 'السبعون',
                    80 => 'الثمانون',
                    90 => 'التسعون'
                ],
                'and' => ' و'
            ],
            'en' => [
                'ones' => [
                    1 => 'first',
                    2 => 'second',
                    3 => 'third',
                    4 => 'fourth',
                    5 => 'fifth',
                    6 => 'sixth',
                    7 => 'seventh',
                    8 => 'eighth',
                    9 => 'ninth',
                    10 => 'tenth'
                ],
                'teens' => [
                    11 => 'eleventh',
                    12 => 'twelfth',
                    13 => 'thirteenth',
                    14 => 'fourteenth',
                    15 => 'fifteenth',
                    16 => 'sixteenth',
                    17 => 'seventeenth',
                    18 => 'eighteenth',
                    19 => 'nineteenth'
                ],
                'tens' => [
                    20 => 'twentieth',
                    30 => 'thirtieth',
                    40 => 'fortieth',
                    50 => 'fiftieth',
                    60 => 'sixtieth',
                    70 => 'seventieth',
                    80 => 'eightieth',
                    90 => 'ninetieth'
                ],
                'and' => ' and '
            ]
        ];

        if ($number <= 10) {
            return $words[$lang]['ones'][$number];
        } elseif ($number < 20) {
            return $words[$lang]['teens'][$number];
        } else {
            $ten = floor($number / 10) * 10;
            $one = $number % 10;
            if ($one == 0) {
                return $words[$lang]['tens'][$ten];
            } else {
                return $words[$lang]['tens'][$ten] . $words[$lang]['and'] . $words[$lang]['ones'][$one];
            }
        }
    }
    /**  العام الدرراسي الحالي */
    public static function getSchoolYear()
    {
        $currentHijriYear = Hijri::Date('Y');
        $nextHijriYear = $currentHijriYear + 1;
        $schoolYear = $currentHijriYear . '-' . $nextHijriYear;
        return $schoolYear;
    }
    // $type is what date you send
    public static function getDateOptions($date, $type)
    {
        list($day, $month, $year) = explode('/', $date);
        if ($type == "hijri") {
            // Convert Hijri date to coptic
            $coptic = Hijri::DateToGregorianFromDMY((int)$day, (int)$month, (int)$year);
            if ($month == 6) {
                $coptic = Carbon::createFromFormat('Y/m/d', $coptic)->subDay(1)->format('d/m/Y');
            } else {
                $coptic = Carbon::createFromFormat('Y/m/d', $coptic)->format('d/m/Y');
            }
            return ['coptic' => $coptic, 'hijri' => $date];
        } else {
            // // Convert coptic date to Hijri
            $hijri = Hijri::DateFromGregorianDMY((int)$day, (int)$month, (int)$year);
            $westernHijri = static::convertArabicToWesternNumerals($hijri);
            $hijriParts = explode('/', str_replace(['هـ', ' '], '', $westernHijri)); // Remove "هـ" and any spaces
            $hijriFormatted = sprintf("%02d/%02d/%04d", (int)$hijriParts[2], (int)$hijriParts[1], (int)$hijriParts[0]);
            return  ['coptic' => $date, 'hijri' => $hijriFormatted];
        }
    }
    // convert to coptic
    public static function getCoptic($date)
    {
        list($day, $month, $year) = explode('/', $date);
        // Convert Hijri date to coptic
        $coptic = Hijri::DateToGregorianFromDMY((int)$day, (int)$month, (int)$year);
        if ($month == 6) {
            $coptic = Carbon::createFromFormat('Y/m/d', $coptic)->subDay(1)->format('d/m/Y');
        } else {
            $coptic = Carbon::createFromFormat('Y/m/d', $coptic)->format('d/m/Y');
        }
        return  $coptic;
    }

    // convert to coptic
    public static function getHijri($date)
    {
        list($day, $month, $year) = explode('/', $date);
        // // Convert coptic date to Hijri
        $hijri = Hijri::DateFromGregorianDMY((int)$day, (int)$month, (int)$year);
        $westernHijri = static::convertArabicToWesternNumerals($hijri);
        $hijriParts = explode('/', str_replace(['هـ', ' '], '', $westernHijri)); // Remove "هـ" and any spaces
        $hijriFormatted = sprintf("%02d/%02d/%04d", (int)$hijriParts[2], (int)$hijriParts[1], (int)$hijriParts[0]);
        return  $hijriFormatted;
    }

    public static function filterData($modelName, array $filterData, array $with = [])
    {
        $excludedParams = ['page', 'per_page', 'date_type', 'date', 'orderBy', 'date_from', 'date_from_type', 'date_to', 'date_to_type', 'search', 'transaction_number'];
        $query = $modelName::query();
        if (!empty($with)) {
            $query->with($with);
        }
        $columns = Schema::getColumnListing((new $modelName)->getTable());

        foreach ($filterData as $attr => $value) {
            if (in_array($attr, $excludedParams)) {
                continue;
            }
            if (! in_array($attr, $columns)) {
                throw new \InvalidArgumentException("Attribute '{$attr}' does not exist in the table.");
            }

            if (is_array($value)) {
                $query->whereIn($attr, $value);
            } else {
                $query->where($attr, 'like', "%$value%");
            }
        }
        return $query;
    }

    public static function saveSchoolYearCalendar($startDate, $endDate)
    {
        $start = Carbon::createFromFormat('d/m/Y', $startDate);
        $end = Carbon::createFromFormat('d/m/Y', $endDate);
        while ($start->lessThanOrEqualTo($end)) {
            $dayOfWeek = $start->dayOfWeek;
            $dayId = ($dayOfWeek == 0) ? 1 : $dayOfWeek + 1; // Adjust for Sunday = 1, Saturday = 7

            // Save the data to the database
            DB::table('semester_week_days')->insert([
                'semester_id' => 4,
                'week_id' => NULL,
                'day_id' => $dayId,
                'date' => $start->format('d/m/Y'),
                'date_type' => 'coptic',
                'created_at' => now(),
                'updated_at' => now(),
            ]);
            $start->addDay();
        }
    }

    public static function saveSemesterWeekDays($semesterId, $startDate, $endDate)
    {
        $start = Carbon::createFromFormat('d/m/Y', $startDate);
        $end = Carbon::createFromFormat('d/m/Y', $endDate);

        // Loop through the 13 weeks
        for ($week = 1; $week <= 13; $week++) {
            // Loop through all 7 days (Sunday to Saturday)
            for ($day = 0; $day < 7; $day++) {
                // Calculate the day date by adding weeks and days
                $currentDay = $start->copy()->addWeeks($week - 1)->addDays($day);

                // Ensure the day is within the semester period
                if ($currentDay->greaterThan($end)) {
                    break;
                }

                // Get the correct 'day_id' based on Carbon's weekday (1: Sunday, 7: Saturday)
                $dayOfWeek = $currentDay->dayOfWeek; // Carbon's dayOfWeek: 0 (Sunday) to 6 (Saturday)
                // Map Carbon's weekday to your day_id: Sunday=1, Monday=2, ..., Saturday=7
                $dayId = ($dayOfWeek == 0) ? 1 : $dayOfWeek + 1; // Adjust for Sunday = 1, Saturday = 7
                // update the data to the database
                DB::table('semester_week_days')->where('date', $currentDay->format('d/m/Y'))->update(['semester_id' => $semesterId, 'week_id' => $week]);
            }
        }
    }


    public static function saveShiftSchedules($semesterId, $startDate, $endDate)
    {
        ShiftSchedule::where('semester_id', $semesterId)->forceDelete();

        $start = Carbon::createFromFormat('d/m/Y', $startDate);
        $end = Carbon::createFromFormat('d/m/Y', $endDate);

        // Loop through the 13 weeks to add shifts tables
        for ($week = 1; $week <= 13; $week++) {
            // Save the data to the database
            DB::table('shift_schedules')->insert([
                'semester_id' => $semesterId,
                'week_id' => $week,
                'created_at' => now(),
                'updated_at' => now(),
            ]);
        }

        $shiftSchedules = ShiftSchedule::where('semester_id', $semesterId)->get();

        foreach ($shiftSchedules as $shiftSchedule) {

            $weekDays = SemesterWeekDay::where('semester_id', $shiftSchedule->semester_id)->where('week_id', $shiftSchedule->week_id)->whereNotIn('day_id', [6, 7])->get();

            foreach ($weekDays as $weekDay) {
                DB::table('shift_schedule_days')->insert([
                    'shift_schedule_id' => $shiftSchedule->id,
                    'semester_week_day_id' => $weekDay->id,
                    'semester_id' => $weekDay->semester_id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }

    public static function saveTeacherSchedules($schoolId)
    {

        $schoolSemesters = SchoolSemester::where('status', '1')->get();
        $classes = SchoolClass::where('school_id', $schoolId)->get();
        foreach ($schoolSemesters as $schoolSemester) {
            foreach ($classes as $class) {
                // Save the data to the database
                TeacherSchedule::updateOrcreate([
                    'school_id' => $schoolId,
                    'semester_id' => $schoolSemester->id,
                    'school_class_id' => $class->id
                ]);
                // DB::table('teacher_schedules')->insert([
                // ]);
            }
        }
    }

    public static function saveSupervisionSchedules($schoolId)
    {
        $check = SupervisionSchedul::where('school_id', $schoolId)
            ->where('namazeg_version_id', null)->get();
        $namozeg = Namazeg::where('form_number', '49')->first();
        // if (! $check->count() > 0) {
        //     $check->delete();
        if ($check->isNotEmpty()) {
            $check->each(function ($item) {
                $item->delete(); // Deletes each item in the collection
            });
            $schoolSemesters = SchoolSemester::where('status', '1')->get();
            foreach ($schoolSemesters as $schoolSemester) {
                $namozeg_version = self::storeNamazegVersion(
                    $namozeg->id,
                    $namozeg->internal_extenral,
                    $schoolId
                );
                SupervisionSchedul::updateOrcreate([
                    'title' => 'جدول الأشراف الأسبوعي',
                    'school_id' => $schoolId,
                    'semester_id' => $schoolSemester->id,
                ], [
                    'namazeg_version_id' => $namozeg_version->id,
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
                // Save the data to the database
                // DB::table('supervision_schedules')->insert([
                //     'title' => 'جدول الأشراف الأسبوعي',
                //     'namazeg_version_id' => $namozeg_version->id,
                //     'school_id' => $schoolId,
                //     'semester_id' => $schoolSemester->id,
                //     'created_at' => now(),
                //     'updated_at' => now(),
                // ]);
            }
        }
    }

    private static function convertArabicToWesternNumerals($arabicNumber)
    {
        $westernNumbers = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9'];
        $arabicNumbers = ['٠', '١', '٢', '٣', '٤', '٥', '٦', '٧', '٨', '٩'];

        return str_replace($arabicNumbers, $westernNumbers, $arabicNumber);
    }




    public static function managerPlans($school_id)
    {
        $check = NamazegManagerPlane::where('school_id', $school_id)->whereIn('semester_id', [1, 2, 3])->count();
        if ($check >= 51) {
            return;
        }
        $semesters = SchoolSemester::where('status', '1')->get();
        $namozeg = Namazeg::where('form_number', '131')->first();
        $school = School::findOrFail($school_id);
        $hijri_year = substr(Hijri::Date('Y'), -2);
        $weeks = Week::all()->keyBy('id');
        $managerPlanes = [];

        foreach ($semesters as $semester) {
            $managerPlanes[] = [
                'semester_id' => $semester->id,
                'school_id' => $school_id,
                'week_name' => "بداية العام الدراسي",
                'week_id' => null,
                'title' => 'الخطة الإسبوعية',
                'status' => 'notdone',
            ];

            $managerPlanes[] = [
                'semester_id' => $semester->id,
                'school_id' => $school_id,
                'week_name' => "الإسبوع التمهيدي",
                'week_id' => 110,
                'title' => 'الخطة الإسبوعية',
                'status' => 'notdone',
            ];

            for ($week = 1; $week <= 13; $week++) {
                $managerPlanes[] = [
                    'semester_id' => $semester->id,
                    'school_id' => $school_id,
                    'week_name' => 'الاسبوع ' . ($weeks->get($week)->name ?? ''),
                    'week_id' => $week,
                    'title' => 'الخطة الإسبوعية',
                    'status' => 'notdone',
                ];
            }

            // $managerPlanes[] = [
            //     'semester_id' => $semester->id,
            //     'school_id' => $school_id,
            //     'week_name' => 'مفكرة',
            //     'week_id' => 111,
            //     'title' => 'مفكرة مواعيد '. $semester->name,
            //     'status' => 'notdone',
            // ];

            // $managerPlanes[] = [
            //     'semester_id' => $semester->id,
            //     'school_id' => $school_id,
            //     'week_name' => 'مرئيات ومقترحات',
            //     'week_id' => 112,
            //     'title' => 'مرئيات ومقترحات لتطوير الخطة مستقبلًا',
            //     'status' => 'notdone',
            // ];
        }

        $current_year = substr(Hijri::Date('Y'), -2); // Hijri year, last 2 digits
        $version = 1;
        $base_serial_number = $current_year . '-' . $namozeg->id . '-';

        foreach ($managerPlanes as &$managerPlane) { // Use reference to modify $managerPlane directly

            $check_record = NamazegManagerPlane::where('school_id', $managerPlane['school_id'])->where('semester_id', $managerPlane['semester_id'])
                ->where('week_id', $managerPlane['week_id'])->first();
            if (!$check_record) {
                // Generate a unique serial number
                do {
                    $newSerialNumber = $base_serial_number . $version++;
                    $existingVersion = NamazegVersion::where('serial_number', $newSerialNumber)->first();
                } while ($existingVersion);

                // Create a new NamazegVersion
                $namazegVersion = NamazegVersion::create([
                    'namazeg_id' => '131',
                    'school_id' => $school_id,
                    'serial_number' => $newSerialNumber,
                ]);

                // Attach the NamazegVersion ID to the managerPlane
                $managerPlane['namazeg_version_id'] = $namazegVersion->id;

                // Update or create the record
                NamazegManagerPlane::updateOrCreate(
                    [
                        'school_id' => $managerPlane['school_id'],
                        'semester_id' => $managerPlane['semester_id'],
                        'week_id' => $managerPlane['week_id'], // Unique identifiers
                    ],
                    $managerPlane // Values to update or insert
                );
            }
        }
    }


    public static function get_first_last_semester_Day($week_id, $semester_id)
    {
        $start_day = SemesterWeekDay::where('semester_id', $semester_id)->where('week_id', $week_id)->orderBy('day_id', 'asc')->first();
        $end_day = SemesterWeekDay::where('semester_id', $semester_id)->where('week_id', $week_id)->orderBy('day_id', 'desc')->first();
        return [$start_day, $end_day];
    }

    public static function getCurrentSchoolSemester($date = null)
    {
        $date = $date ? $date : date('d/m/Y');
        $day = Carbon::createFromFormat('d/m/Y', $date);

        $schoolSemesters = SchoolSemester::get();
        $closestSemester = null;
        $minDiff = PHP_INT_MAX;

        foreach ($schoolSemesters as $schoolSemester) {
            if ($schoolSemester->id != 4) { // Exclude the 4th semester from range checking
                $startDate = Carbon::createFromFormat('d/m/Y', $schoolSemester->start_date);
                $endDate = Carbon::createFromFormat('d/m/Y', $schoolSemester->end_date);

                // Check if the date is within the current semester's range
                if ($day->between($startDate, $endDate)) {
                    return $schoolSemester;
                }

                // Calculate the closest semester based on proximity
                $diff = min(
                    $day->diffInDays($startDate),
                    $day->diffInDays($endDate)
                );

                if (abs($diff) < $minDiff) {
                    $minDiff = abs($diff);
                    $closestSemester = $schoolSemester;
                }
            }
        }

        // Return the closest semester if no exact match is found
        return $closestSemester ?: $schoolSemesters->firstWhere('id', 4);
    }
    public static function getCurrentToLastSchoolSemester($date = null)
    {
        $date = $date ? $date : date('d/m/Y');
        $day = Carbon::createFromFormat('d/m/Y', $date);

        $schoolSemesters = SchoolSemester::get();
        $closestSemester = null;
        $minDiff = PHP_INT_MAX;

        foreach ($schoolSemesters as $schoolSemester) {
            if ($schoolSemester->id != 4) {
                $startDate = Carbon::createFromFormat('d/m/Y', $schoolSemester->start_date);
                $endDate = Carbon::createFromFormat('d/m/Y', $schoolSemester->end_date);
                if ($day->between($startDate, $endDate)) {
                    return $schoolSemester;
                }
                if ($endDate->lt($day)) {
                    $diff = $day->diffInDays($endDate);

                    if ($diff < $minDiff) {
                        $minDiff = $diff;
                        $closestSemester = $schoolSemester;
                    }
                }
            }
        }
        if ($closestSemester->id != 3) {
            return $closestSemester;
        } else {
            return $schoolSemesters->firstWhere('id', 4);
        }
    }

    // public static function getClosestSemester()
    // {
    //     $date = date('d/m/Y', strtotime('-2 days'));
    //     $day =  Carbon::createFromFormat('d/m/Y', $date);
    //     $schoolSemesters = SchoolSemester::where('status', '1')->get();
    //     foreach ($schoolSemesters as $schoolSemester) {
    //         $startDate = Carbon::createFromFormat('d/m/Y', $schoolSemester->start_date);
    //         $endDate = Carbon::createFromFormat('d/m/Y', $schoolSemester->end_date);
    //         if ($day->between($startDate, $endDate)) {
    //             return $schoolSemester;
    //         }
    //     }
    //     return null;
    // }


    public static function checkExamStartDate($day, $semesterId)
    {
        $day = Carbon::createFromFormat('d/m/Y', $day);
        $schoolSemester = SchoolSemester::find($semesterId);
        $startDate = Carbon::createFromFormat('d/m/Y', $schoolSemester->start_date);
        $endDate = Carbon::createFromFormat('d/m/Y', $schoolSemester->end_date);
        if ($day->between($startDate, $endDate)) {
            // Calculate the remaining days until the semester ends
            $daysRemaining = $day->diffInDays($endDate, false); // false to include today
            // Check if there are at least 4 days remaining in the semester
            if ($daysRemaining >= 4) {
                return true;
            } else {
                return false;
            }
        }
        return false;
    }


    public static function autocomplete($modelName, $columnName, $query)
    {
        // Ensure that the $modelName is treated as a fully qualified class name
        if (class_exists($modelName)) {
            // Use the dynamic model name to perform the query
            $results = $modelName::where($columnName, 'LIKE', "%{$query}%")
                ->select('id', $columnName)
                ->get();
            return response()->json($results);
        }

        // Return an error response if the model class doesn't exist
        return response()->json(['error' => 'Model not found'], 404);
    }

    public static function get_first_last_Day_of_semester_weeks($semester_id)
    {
        $week_days = SemesterWeekDay::with('week')
            ->where('semester_id', $semester_id)
            ->orderBy('week_id', 'asc')
            ->orderBy('day_id', 'asc')
            ->get();

        $weeks = $week_days->groupBy('week_id');
        $result = [];
        foreach ($weeks as $week) {
            $first_day = $week->first();
            $result[] = [
                'week_name' => $first_day->week->name,
                'first_date' => $first_day->date,
            ];
        }

        return $result;
    }

    /** function get working days from specific date */
    public static function getWorkingDays($startDate, $numberOfDays)
    {
        // Ensure the startDate is a Carbon instance, parsing it in d/m/Y format if necessary
        if (!$startDate instanceof Carbon) {
            // Parse the start date in 'd/m/Y' format
            $startDate = Carbon::createFromFormat('d/m/Y', $startDate);
        }

        $workingDays = [];
        $currentDate = $startDate->copy();

        while (count($workingDays) < $numberOfDays) {
            // Check if the day is not Friday or Saturday
            if (!$currentDate->isFriday() && !$currentDate->isSaturday()) {
                // Add the formatted date to the array
                $workingDays[] = $currentDate->format('d/m/Y');
            }

            // Move to the next day
            $currentDate->addDay();
        }

        return $workingDays;
    }


    public static function storeSchoolManagerAssignment($schoolId)
    {
        // Retrieve the manager associated with the school
        $manager = SchoolEmployee::where('current_work_id', 1)
            ->where('school_id', $schoolId)
            ->first();

        if ($manager) {
            // Fetch the Namazeg based on the specific form number
            $namozeg = Namazeg::firstWhere('form_number', 14);

            // Check if a NamazegVersion already exists for the school and namozeg_id
            $existingVersion = NamazegVersion::where('namazeg_id', $namozeg->id)
                ->where('school_id', $schoolId)
                ->first();


            if (!$existingVersion) {
                // If no version exists, create a new one using the trait method
                $namozeg_version = self::storeNamazegVersion(
                    $namozeg->id,
                    $namozeg->internal_extenral,
                    $schoolId
                );
            } else {
                // Use the existing version
                $namozeg_version = $existingVersion;
            }

            // Create the default assignment
            $assignment = Assignment::create([
                'namazeg_version_id' => $namozeg_version->id,
                'school_id' =>  $schoolId,
                'date' => now()->format('d/m/Y'),
                'current_work_id' => 1,
                'date_type' => 'coptic',
            ]);

            // Link the manager to the assignment
            AssignmentEmployee::create([
                'assignment_id' => $assignment->id,
                'employee_id' => $manager->id,
            ]);
        }
    }

    /** usesd to match school grade with class name grade */
    public static function findCommonSubstrings($string1, $string2)
    {
        $common = '';
        $len1 = mb_strlen($string1);
        $len2 = mb_strlen($string2);

        for ($i = 0; $i < $len1; $i++) {
            for ($j = $i + 1; $j <= $len1; $j++) {
                $substr = mb_substr($string1, $i, $j - $i);
                if (mb_strpos($string2, $substr) !== false && mb_strlen($substr) > mb_strlen($common)) {
                    $common = $substr;
                }
            }
        }

        // If the common substring is too small (less than 4 characters), treat as no match
        return mb_strlen($common) > 3 ? $common : '';
    }


    public static function store_default_notification_settings($school_id)
    {
        $notifcations = NotificationSetting::all();
        $check = NotificationSchoolSetting::where('school_id', $school_id)->first();
        if (!$check) {
            foreach ($notifcations as $notif) {
                NotificationSchoolSetting::create([
                    'school_id' => $school_id,
                    'notification_setting_id' => $notif->id,
                    'website_disability' => $notif->website_disability,
                    'app_disability' => $notif->app_disability,
                    'messages_disability' => $notif->messages_disability,
                ]);
            }
        }
    }

    public static function  formatPhoneNumber($phone)
    {
        // Step 1: Remove '966' country code if present at the beginning
        if (substr($phone, 0, 3) === '966') {
            $phone = substr($phone, 3);
        }

        // Step 2: Ensure the number starts with '05'
        if (substr($phone, 0, 2) !== '05') {
            $phone = '0' . $phone;
        }
        return $phone;
    }
}
