<?php

namespace App\Factories;

use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegRedirectGuidanceRequest;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Assignments\AssignmentCommittee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegRedirectGuidance;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\Committee;
use App\Models\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeMember;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg160Factory implements NamozegFactory
{
    //  نموذج إحالة لإدارة قسم التوجيه الطلاب
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '160')->first();
        $student_id = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $student_id;

        $destructionProceed = new NamazegRedirectGuidanceRequest($request->all());
        $data = $destructionProceed->toArray();
        NamazegRedirectGuidance::create($data);

        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $incidentProceedRequest = new NamazegRedirectGuidanceRequest($request->all());
        $data = $incidentProceedRequest->toArray();
        NamazegRedirectGuidance::where('namazeg_version_id', $namozeg_version_id)->update($data);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $namazegRedirectGuidance = NamazegRedirectGuidance::with('namozegVersion', 'student', 'VStudentPunishment')->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $namazegRedirectGuidance->student->school;
        $student = $namazegRedirectGuidance->student;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;
        $violation_grade = $namazegRedirectGuidance->VStudentPunishment->VStudentTitle->ViolationStudent->violationGrade;
        $violation_type = $namazegRedirectGuidance->VStudentPunishment->VStudentTitle->ViolationStudent->type;
        $commite = Committee::with('members')->where('assignment_form_number', 33)->firstOrFail();
        $assignment = AssignmentCommittee::where('school_id', $school->id)
            ->where('committee_id', $commite->id)->firstOrFail();
        $commite_manager = CommitteeMember::with('employee')->where('assignment_committee_id', $assignment->id)->get()->filter(
            function ($member) {
                return $member->employee->current_work_id == 10;
            }
        )->first();



        return [
            'form_number' => $namazegRedirectGuidance->namozegVersion->namozeg->form_number,
            'serial_number' => $namazegRedirectGuidance->namozegVersion->serial_number,
            'schoolClass' => $student->schoolClass->className->name,
            'student_name' => $student->name,
            'redirect_reason' => $namazegRedirectGuidance->redirect_reason,
            'violation_type' => $violation_type ? $violation_type->name : $namazegRedirectGuidance->VStudentPunishment->VStudentTitle->ViolationStudent->other_type,
            'violation_grade_name' => $violation_grade->name,
            'actions' => $namazegRedirectGuidance->actions,
            'not_response_reason' => $namazegRedirectGuidance->not_response_reason,
            'attach' => $namazegRedirectGuidance->attach,
            'attach_reason' => $namazegRedirectGuidance->attach_reason,
            'phone' => $namazegRedirectGuidance->phone,
            'commite_manager' => $commite_manager?->employee?->name,
            'manager_name' => $manager_name
        ];
    }
}
