<?php

namespace App\Factories;

use App\Helpers\Helper;
use App\Http\Requests\ManagerDashboard\Namazeg\Violations\NamazegSafetyCallRequest;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Models\ManagerDashboard\Namazeg\Violations\NamazegSafetyCall;
use App\Models\ManagerDashboard\Violations\ViolationStudentPunishment;
use App\Models\Namazeg;
use App\Traits\NamazegTrait;
use Illuminate\Foundation\Http\FormRequest;

class Namozeg132Factory implements NamozegFactory
{
    //  نموذج استمارة استدعاء جهة أمنية
    use NamazegTrait;
    public function store($school_id, $violation_student_punishment, FormRequest $request)
    {
        $namozeg = Namazeg::where('form_number', '132')->first();
        $student_id = $violation_student_punishment->VStudentTitle->ViolationStudent->student_id;
        $namozeg_version = $this->storeNamazegVersion(
            $namozeg->id,
            $namozeg->internal_extenral,
            $school_id
        );
        $request['v_student_punishment_id'] = $violation_student_punishment->id;
        $request['namazeg_version_id'] = $namozeg_version->id;
        $request['student_id'] = $student_id;

        $destructionProceed = new NamazegSafetyCallRequest($request->all());
        $data = $destructionProceed->toArray();
        NamazegSafetyCall::create($data);       

        return $namozeg_version;
    }

    public function update($namozeg_version_id, FormRequest $request)
    {
        $incidentProceedRequest = new NamazegSafetyCallRequest($request->all());
        $data = $incidentProceedRequest->toArray();
        NamazegSafetyCall::where('namazeg_version_id', $namozeg_version_id)->update($data);
        return $namozeg_version_id;
    }


    public function handle($school, $request, $namozeg_version)
    {
        $namazeg_version_id = $namozeg_version->namazeg_version_id ?? $namozeg_version->id;
        $NamazegSafetyCall = NamazegSafetyCall::with('namozegVersion','student', 'employee' )->where('namazeg_version_id', $namazeg_version_id)->firstOrFail();
        $school = $NamazegSafetyCall->student->school;
        $manager_name = SchoolEmployee::where('school_id', $school->id)->where('current_work_id', 1)->first()?->name;

        return [
            'form_number' => $NamazegSafetyCall->namozegVersion->namozeg->form_number,
            'serial_number' => $NamazegSafetyCall->namozegVersion->serial_number,
            'issued_to'=>$NamazegSafetyCall->issued_to,
            'call_name'=>$NamazegSafetyCall->call_name,
            'reason'=>$NamazegSafetyCall->reason,
            'call_time'=>$NamazegSafetyCall->call_time,
            'text'=>$NamazegSafetyCall->text,
            'student_name' => $NamazegSafetyCall->student->name,
            'caller'=> $NamazegSafetyCall->employee?->name,
            'caller_work'=> $NamazegSafetyCall->employee?->currentWork->job_title,
            'manager_name' => $manager_name,

            
        ];
    }
}
