<?php

namespace App\Exports;

use Carbon\Carbon;

use App\Models\AdminDashboard\Coupons\Coupon;
use App\Models\ManagerDashboard\Settings\Subscription;
use Maatwebsite\Excel\Concerns\FromCollection;


class CouponUsageHistoryExport implements FromCollection
{
    protected $startDate;
    protected $endDate;
    protected $coupon;

    public function __construct($startDate = null, $endDate = null, $coupon)
    {
        $this->coupon = $coupon;
        // Check if the start and end dates are provided and format them using Carbon
        $this->startDate = $startDate ? Carbon::createFromFormat('d/m/Y', $startDate)->format('Y-m-d H:i:s') : null;
        $this->endDate = $endDate ? Carbon::createFromFormat('d/m/Y', $endDate)->format('Y-m-d H:i:s') : null;
    }

    /**
     * @return \Illuminate\Support\Collection
     */
    public function collection()
    {

        // If both startDate and endDate are provided, filter by the date range
        if (!is_null($this->startDate) && !is_null($this->endDate)) {

            $subscriptions =  Subscription::where('coupon_id', $this->coupon->id)
                ->whereBetween('created_at', [$this->startDate, $this->endDate])->get();

            return  $subscriptions->map(function ($subscription) {
                return [
                    'order_number' => $subscription->order_number,
                    'user' =>  $subscription->user->name,
                    'coupon_discount' =>  $subscription->coupon_discount,
                    'total_before_discount' => $subscription->subscription_fee,
                    'total_price' => $subscription->total_price,
                ];
            });
        }

        // If no date range is provided, return all coupons
        $subscriptions =  Subscription::where('coupon_id', $this->coupon->id)->get();
        return  $subscriptions->map(function ($subscription) {
            return [
                'order_number' => $subscription->order_number,
                'user' =>  $subscription->user->name,
                'coupon_discount' =>  $subscription->coupon_discount,
                'total_before_discount' => $subscription->subscription_fee,
                'total_price' => $subscription->total_price,
            ];
        });
    }
}
