<?php

use App\Http\Controllers\Api\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeController;
use App\Http\Controllers\Api\ManagerDashboard\TeamAndCommitteeMeetings\CommitteeMeetingController;
use App\Http\Controllers\Api\ManagerDashboard\TeamAndCommitteeMeetings\TeamController;
use App\Http\Controllers\Api\ManagerDashboard\TeamAndCommitteeMeetings\TeamMeetingController;
use Illuminate\Support\Facades\Route;


    /*committees */
    Route::group(['prefix' => 'committees', 'controller' => CommitteeController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('{committee}/details', 'getById');
        Route::post('store', 'store');
        Route::post('{committee}/update', 'update');
        Route::post('{committee}/change-status', 'changeStatus');
        Route::delete('{committee}/archive', 'archive');
        Route::delete('{committee}/destroy', 'destroy')->withTrashed();
        Route::get('{committee}/restore', 'restore')->withTrashed();
    });

    /*teams */
    Route::group(['prefix' => 'teams', 'controller' => TeamController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('{team}/details', 'getById');
        Route::post('store', 'store');
        Route::post('{team}/update', 'update');
        Route::post('{team}/change-status', 'changeStatus');
        Route::delete('{team}/archive', 'archive');
        Route::delete('{team}/destroy', 'destroy')->withTrashed();
        Route::get('{team}/restore', 'restore')->withTrashed();
    });

    /*committees */
    Route::group(['prefix' => 'committees-meetings', 'controller' => CommitteeMeetingController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('{meeting}/details', 'getById');
        Route::post('store', 'store');
        Route::post('{meeting}/store-meeting-details', 'storeExtra');
        Route::post('{meeting}/save-as-draft', 'saveAsDraft');
        Route::post('{meeting}/update', 'update');
        Route::post('{meeting}/change-status', 'changeStatus');
        Route::delete('{meeting}/archive', 'archive');
        Route::delete('{meeting}/destroy', 'destroy')->withTrashed();
        Route::get('{meeting}/restore', 'restore')->withTrashed();
    });

    /* committees */
    Route::group(['prefix' => 'teams-meetings', 'controller' => TeamMeetingController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('{meeting}/details', 'getById');
        Route::post('store', 'store');
        Route::post('{meeting}/store-meeting-details', 'storeExtra');
        Route::post('{meeting}/save-as-draft', 'saveAsDraft');
        Route::post('{meeting}/update', 'update');
        Route::post('{meeting}/change-status', 'changeStatus');
        Route::delete('{meeting}/archive', 'archive');
        Route::delete('{meeting}/destroy', 'destroy')->withTrashed();
        Route::get('{meeting}/restore', 'restore')->withTrashed();
    });