<?php

use App\Http\Controllers\Api\ManagerDashboard\Circulars\InternalCircularController;
use App\Http\Controllers\Api\ManagerDashboard\Circulars\StudentGeneralCircularController;
use App\Http\Controllers\Api\ManagerDashboard\Circulars\TeacherGeneralCircularController;
use Illuminate\Support\Facades\Route;


/* procedures */
Route::group(['prefix' => 'circulars'], function () {

    Route::group(['prefix' => 'internal-circulars', 'controller' => InternalCircularController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('{internal_circular}/details', 'getById');
        Route::post('store', 'store');
        Route::post('{internal_circular}/update', 'update');
        Route::delete('{internal_circular}/archive', 'archive');
        Route::delete('{internal_circular}/destroy', 'destroy')->withTrashed();
        Route::get('{internal_circular}/restore', 'restore')->withTrashed();
    });

    Route::group(['prefix' => 'teacher-general-circulars', 'controller' => TeacherGeneralCircularController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('{teacher_general_circular}/details', 'getById');
        Route::post('store', 'store');
        Route::post('{teacher_general_circular}/update', 'update');
        Route::delete('{teacher_general_circular}/archive', 'archive');
        Route::delete('{teacher_general_circular}/destroy', 'destroy')->withTrashed();
        Route::get('{teacher_general_circular}/restore', 'restore')->withTrashed();
    });

    Route::group(['prefix' => 'student-general-circulars', 'controller' => StudentGeneralCircularController::class], function () {
        Route::get('get-all', 'getAll');
        Route::get('{student_general_circular}/details', 'getById');
        Route::post('store', 'store');
        Route::post('{student_general_circular}/update', 'update');
        Route::delete('{student_general_circular}/archive', 'archive');
        Route::delete('{student_general_circular}/destroy', 'destroy')->withTrashed();
        Route::get('{student_general_circular}/restore', 'restore')->withTrashed();
    });

});