<?php

use App\Http\Controllers\Api\ManagerDashboard\Assignments\AssignmentCommitteeController;
use Illuminate\Support\Facades\Route;
use  App\Http\Controllers\Api\ManagerDashboard\Assignments\AssignmentController;
use App\Http\Controllers\Api\ManagerDashboard\Assignments\AssignmentTeamController;
use App\Http\Controllers\Api\ManagerDashboard\Assignments\GeneralAssignmentController;

Route::group(['prefix' => 'assignments'], function () {


    Route::group([ 'controller' => AssignmentController::class], function () {

        Route::get('{school}/categories','getCategories');
      
    });

    Route::group([ 'prefix' => 'SchoolStaff' ,'controller' => AssignmentController::class], function () {

        Route::POST('store','store');
        Route::delete('{assignment}/{employeeId}/archive', 'archive');
        Route::get('{assignment}/{employeeId}/restore', 'restore');
        Route::Delete('{assignment}/{employeeId}/delete','destroy');
    }); 

    Route::group([ 'prefix' => 'committees' ,'controller' => AssignmentCommitteeController::class], function () {

        Route::POST('{committee}/store','store');
        Route::delete('{committee}/{assignment}/archive', 'archive');
        Route::get('{committee}/{assignment}/restore', 'restore');
        Route::delete('{committee}/{assignment}/delete','destroy');
    });
    

    Route::group([ 'prefix' => 'teams' ,'controller' => AssignmentTeamController::class], function () {

        Route::POST('{team}/store','store');
        Route::delete('{team}/{assignment}/archive', 'archive');
        Route::get('{team}/{assignment}/restore', 'restore');
        Route::delete('{team}/{assignment}/delete','destroy');
    });


    Route::group([ 'prefix' => 'general' ,'controller' => GeneralAssignmentController::class], function () {

        Route::POST('store','store');
        Route::delete('{assignment}/archive', 'archive');
        Route::get('{assignment}/restore', 'restore')->withTrashed();
        Route::delete('{assignment}/delete','destroy');
    });


});
