<?php

use Illuminate\Support\Facades\Route;

///////// user operations urls/////////////////
Route::group(['prefix' => 'auth', 'namespace' => 'User'], function () {

    Route::post('login', 'AuthController@authenticate');
    Route::post('verfiy-login', 'AuthController@verfiyLogin');
    Route::post('refreshToken', 'AuthController@refreshToken');
    Route::post('validateToken', 'AuthController@validateToken');
    Route::post('register', 'AuthController@register');
    Route::post('account-verfication', 'AuthController@accountVerfication');
    Route::post('send-reset-password-via-email', 'AuthController@sendResetPasswordEmail');
    Route::post('send-reset-password-via-sms', 'AuthController@sendResetPasswordViaSms');
    Route::post('resend-otp', 'AuthController@resndOtp');

});

////// routes group that need to be authorized user//////
Route::group(['middleware' => ['jwt.verify']], function () {
    Route::group(['prefix' => 'user', 'namespace' => 'User'], function () {

        /* return user info */
        Route::get('profile', 'UserController@getUserProfile');
        Route::post('update-profile', 'UserController@updateUserProfile');
        Route::post('change-password', 'UserController@changePassword');
        Route::get('roles', 'UserController@getRoles');
        Route::post('change-status', 'UserController@changeStatus');
        Route::get('get-all-admins', 'UserController@getAllAdmins');
        Route::post('create-new-admin', 'UserController@createNewAdmin');
        Route::post('update-admin ', 'UserController@createNewAdmin');
        Route::post('removeUser', 'AuthController@removeUser');


        /*  permissions url */
        Route::get('permissions/get-super-admin-permissions', 'PermissionController@SuperAdminPermissions');
        Route::get('permissions/get-school-manager-permissions', 'PermissionController@SchoolManagerPermissions');
        Route::post('permissions/create-pemission', 'PermissionController@store');
        Route::post('permissions/update-pemission-group', 'PermissionController@updatePermissionGroup');
        Route::post('permissions/update-pemission', 'PermissionController@updatePermission');
        Route::post('permissions/delete-pemission-group', 'PermissionController@deletePermissionGroup');
        Route::post('permissions/delete-pemission', 'PermissionController@deletePermission');

        /*  permissions url */
        Route::get('roles/get-all', 'RoleController@getAll');
        Route::post('roles/create', 'RoleController@store');
        Route::post('roles/update', 'RoleController@update');
        Route::post('roles/delete', 'RoleController@delete');
    });
});
