<?php

namespace Database\Seeders;

use App\Models\AdminDashboard\School\Specialization as SchoolSpecialization;
use Illuminate\Database\Seeder;

class SpecializationsTableSeeder extends Seeder
{
    /**
     * Seed the specializations table.
     *
     * @return void
     */
    public function run()
    {
        $specializations = [
            // Boys
            'التربية الاسلامية',
            'اللغة العربية',
            'اللغة الانجليزية',
            'التربية الاجتماعية والوطنية',
            'العلوم',
            'الرياضيات',
            'حاسب',
            'التربية البدنية',
            'التربية الفنية',
            'محضر مختبر',
            'اخرى (يسجل بشكل الكتروني)',

            // Middle School Boys
            'التربية الاسلامية',
            'اللغة العربية',
            'اللغة الانجليزية',
            'التربية الاجتماعية والوطنية',
            'العلوم',
            'الرياضيات',
            'الحاسب الالي',
            'التربية الفنية',
            'التربية البدنية',
            'محضر مختبر',
            'اللغة الصينية',
            'اخرى (يسجل بشكل الكتروني)',

            // High School Boys
            'التربية الاسلامية',
            'اللغة العربية',
            'القراءات',
            'المكتبات',
            'علم نفس',
            'علم اجتماع',
            'اللغة الانجليزية',
            'التربية الاجتماعية والوطنية',
            'كيمياء',
            'فيزياء',
            'احياء',
            'علم ارض',
            'رياضيات',
            'إدارة',
            'الحاسب الالي',
            'التربية الفنية',
            'التربية البدنية',
            'محضر مختبر',
            'اللغة الصينية',
            'اخرى (يسجل بشكل الكتروني)',

            // Special Education
            'التربية الفكرية',
            'التوحد',
            'عوق سمعي',
            'صعوبات التعلم',
            'تدريبات نطق',
            'عوق بصري',
            'معلمة تدريبات سلوكية',
            'اخرى (يسجل بشكل الكتروني)',

            // Girls Primary
            'التربية الاسلامية',
            'اللغة العربية',
            'اللغة الانجليزية',
            'التربية الاجتماعية والوطنية',
            'العلوم',
            'الرياضيات',
            'التربية الفنية',
            'التربية الاسرية',
            'اخرى (يسجل بشكل الكتروني)',

            // Girls Middle School
            'العلوم الاسلامية',
            'اللغة العربية',
            'اللغة الانجليزية',
            'التربية الاجتماعية والوطنية',
            'العلوم',
            'الرياضيات',
            'الحاسب الالي',
            'التربية الفنية',
            'اللغة الصينية',
            'التربية الاسرية',
            'اخرى (يسجل بشكل الكتروني)',

            // Girls High School
            'التربية الاسلامية',
            'اللغة العربية',
            'القراءات',
            'المكتبات',
            'علم نفس',
            'علم اجتماع',
            'اللغة الانجليزية',
            'التربية الاجتماعية والوطنية',
            'كيمياء',
            'فيزياء',
            'احياء',
            'علم ارض',
            'رياضيات',
            'إدارة',
            'الحاسب الالي',
            'التربية الفنية',
            'التربية البدنية',
            'محضر مختبر',
            'اللغة الصينية',
            'التربية الاسرية',
            'الاقتصاد المنزلي',
            'اخرى (يسجل بشكل الكتروني)',

            // Early Childhood
            'تخصص رياض الاطفال',
        ];

        foreach ($specializations as $title) {
            SchoolSpecialization::updateOrCreate(
                ['title' => $title], // Avoid duplicates
                ['title' => $title]  // Data to insert
            );
        }
    }
}
