<?php

namespace Database\Seeders;

use App\Models\ManagerDashboard\Assignments\DurationAssignment as AssignmentsDurationAssignment;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class DurationAssignment extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $arabicNumbers = [
            1 => 'سنة',
            2 => 'سنتان',
            3 => 'ثلاث سنوات',
            4 => 'أربع سنوات',
            5 => 'خمس سنوات',
            6 => 'ست سنوات',
            7 => 'سبع سنوات',
            8 => 'ثمان سنوات',
            9 => 'تسع سنوات',
            10 => 'عشر سنوات',
            11 => 'إحدى عشرة سنة',
            12 => 'اثنتا عشرة سنة',
            13 => 'ثلاث عشرة سنة',
            14 => 'أربع عشرة سنة',
            15 => 'خمس عشرة سنة',
            16 => 'ست عشرة سنة',
            17 => 'سبع عشرة سنة',
            18 => 'ثماني عشرة سنة',
            19 => 'تسع عشرة سنة',
            20 => 'عشرون سنة'
        ];

        foreach ($arabicNumbers as $number => $year) {
            AssignmentsDurationAssignment::create([
                'year' => $year,
            ]);
        }
    }
}
