<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use  App\Models\AdminDashboard\School\CurrentWork;

class CurrentWorkSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $jobTitles = 
       [
            ['jobTitle' => 'مدير المدرسة','assignment_category_id'=>'1', 'assignment_form_number' => '001'],
            ['jobTitle' => 'معلم','assignment_category_id'=>'2', 'assignment_form_number' => '002'],
            ['jobTitle' => 'معلم التربية الخاصة','assignment_category_id'=>'2', 'assignment_form_number' => '003'],
            ['jobTitle' => 'معلم الموهوبين','assignment_category_id'=>'2', 'assignment_form_number' => '004'],
            ['jobTitle' => 'مساعد معلم التربية الخاصة','assignment_category_id'=>'2', 'assignment_form_number' => '004'],
            ['jobTitle' => 'وكيل الشؤون التعليمية','assignment_category_id'=>'1', 'assignment_form_number' => '005'],
            ['jobTitle' => 'وكيل شؤون الطلاب','assignment_category_id'=>'1', 'assignment_form_number' => '006'],
            ['jobTitle' => 'وكيل الشؤون المدرسية','assignment_category_id'=>'1', 'assignment_form_number' => '007'],
            ['jobTitle' => 'مساعد اداري','assignment_category_id'=>'3', 'assignment_form_number' => '008'],
            ['jobTitle' => 'موجه صحي','assignment_category_id'=>'3', 'assignment_form_number' => '009'],
            ['jobTitle' => 'الموجه الطلابي','assignment_category_id'=>'3', 'assignment_form_number' => '0011'],
            ['jobTitle' => 'أمين مصادر التعلم','assignment_category_id'=>'3', 'assignment_form_number' => '0012'],
            ['jobTitle' => 'محضر مختبر','assignment_category_id'=>'3', 'assignment_form_number' => '0013'],
            ['jobTitle' => 'مسجل معلومات','assignment_category_id'=>'3', 'assignment_form_number' => '0014'],
            ['jobTitle' => 'رائد نشاط','assignment_category_id'=>'3', 'assignment_form_number' => '0015'],
            ['jobTitle' => 'حارس المدرسة','assignment_category_id'=>'3', 'assignment_form_number' => '0016'],
            ['jobTitle' => 'عامل الخدمات','assignment_category_id'=>'3', 'assignment_form_number' => '0017'],
            ['jobTitle' => 'موظف الخدمات','assignment_category_id'=>'3', 'assignment_form_number' => '0017'],
            ['jobTitle' => 'سكرتير','assignment_category_id'=>'3', 'assignment_form_number' => '0018'],
            ['jobTitle' => 'مراسل','assignment_category_id'=>'3', 'assignment_form_number' => '0019'],
            ['jobTitle' => 'مستخدم','assignment_category_id'=>'3', 'assignment_form_number' => '0020'],
            ['jobTitle' => 'تكليفات عامة','assignment_category_id'=>'5', 'assignment_form_number' => '0021'],

             
       ];
       foreach ($jobTitles as $jobTitle) {
        CurrentWork::create([
            'job_title' => $jobTitle['jobTitle'],
            'assignment_category_id' => $jobTitle['assignment_category_id'],
            'assignment_form_number' => $jobTitle['assignment_form_number'],
        ]);
    }
    }
}
