<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\ManagerDashboard\Assignments\AssignmentCategory;
use App\Models\ManagerDashboard\Tklfats\TklfatSubCategory;

class AssignmentCategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categoryNames = [
            'إدارة المدرسة'=>[
                ['name' => 'تكليف مدير المدرسة', 'form_number' => '001'],
                ['name' => 'تكليف وكيل الشؤون التعليمية', 'form_number' => '002'],
                ['name' => 'تكليف وكيل شؤون الطلاب', 'form_number' => '003'],
                ['name' => 'تكليف وكيل الشؤون المدرسية', 'form_number' => '004']
            ],
            'المعلمات'=>[
                ['name' => 'تكليف المعلمين', 'form_number' => '005'],
                ['name' => 'تكليف معلمين التربية الخاصة', 'form_number' => '006'],
                ['name' => 'تكليف معلم الموهوبين', 'form_number' => '007'],
                ['name' => 'تكليف مساعد معلم التربية الخاصة', 'form_number' => '008']
            ],
            'منسوبي المدرسة' => [
                ['name' => 'تكليف الموجه الطلابي', 'form_number' => '009'],
                ['name' => 'تكليف رائد النشاط', 'form_number' => '010'],
                ['name' => 'تكليف أمين مصادر التعليم', 'form_number' => '011'],
                ['name' => 'تكليف مساعد إداري', 'form_number' => '012'],
                ['name' => 'تكليف السكرتير', 'form_number' => '013'],
                ['name' => 'تكليف محضر المختبر', 'form_number' => '014'],
                ['name' => 'تكليف الموجه الصحي', 'form_number' => '015'],
                ['name' => 'تكليف مسجل المعلومات', 'form_number' => '016'],
                ['name' => 'تكليف الحارس', 'form_number' => '017'],
                ['name' => 'تكليف عامل الخدمات', 'form_number' => '018'],
                ['name' => 'تكليف موظف الخدمات', 'form_number' => '019']
            ],
            'اللجان و الفرق' => [
                ['name' => 'تكليف اللجان', 'form_number' => '020'],
                ['name' => 'تكليف الفرق', 'form_number' => '021']
            ],
            'التكليفات العامة' => [
                ['name' => 'تكليفات عامة', 'form_number' => '022']
            ]
        ];
    
        foreach($categoryNames as $categoryName => $subCategoryDetails){
            $category = AssignmentCategory::create(['name'=> $categoryName]);
    
            // foreach($subCategoryDetails as $subCategoryDetail){
            //     TklfatSubCategory::create([
            //         'category_id'=> $category->id,
            //         'name'=> $subCategoryDetail['name'],
            //         'form_number'=> $subCategoryDetail['form_number']
            //     ]);
            // }
        }
    }
    
}
