<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_final_report_class_activities', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->unsignedBigInteger('school_id');

            $table->integer('n_medical_sessions');
            $table->integer('percent_medical_sessions');
            $table->integer('n_ernrichment_sessions');
            $table->integer('percent_ernrichment_sessions');
            $table->string('employee_ids');
            $table->string('difficulty');
            $table->string('challenges');
            $table->string('solutions');
            $table->string('suggestions');
            $table->string('date');
            
            $table->foreign('namazeg_version_id')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_final_report_class_activities');
    }
};
