<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('namazeg_assign_professional_communities', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('namazeg_version_id');
            $table->unsignedBigInteger('school_id');

            $table->unsignedBigInteger('specialize_id');
            $table->string('date');
            $table->string('start_date');
            $table->foreign('specialize_id')->references('id')->on('specializations')->onDelete('cascade');

            $table->foreign('namazeg_version_id', 'delete_namazeg_version')->references('id')->on('namazeg_versions')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('namazeg_assign_professional_communities');
    }
};
