<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('proceed_users', function (Blueprint $table) {
            $table->foreign('employee_id')
            ->references('id')
                ->on('school_employees')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('proceed_users', function (Blueprint $table) {
            // Drop the foreign key with cascade delete
            $table->dropForeign(['employee_id']);
        });


    }
};
