<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('class_visit_recommendations', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('classVisit_id');
            $table->text('level_of_implementation_recommendations')->nullable();
            $table->text('strengths_and_excellence')->nullable();
            $table->text('supervisor_support')->nullable();
            $table->text('recommendation')->nullable();
            $table->text('teacher_benefit')->nullable();
            $table->timestamps();

            $table->foreign('classVisit_id')->references('id')->on('class_room_visit_sessions')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('class_visit_recommendations');
    }
};
