<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSemesterWeekDaysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('semester_week_days', function (Blueprint $table) {
            $table->id();  // UNSIGNED BIGINT, auto-incrementing primary key
            $table->unsignedBigInteger('semester_id')->nullable();  // UNSIGNED BIGINT, nullable
            $table->unsignedBigInteger('week_id')->nullable();  // UNSIGNED BIGINT, nullable
            $table->unsignedBigInteger('day_id')->nullable();  // UNSIGNED BIGINT, nullable
            $table->string('date', 50)->nullable()->collation('utf8mb4_general_ci');  // VARCHAR(50), nullable with specified collation
            $table->enum('date_type', ['hijri', 'coptic'])->nullable()->collation('utf8mb4_general_ci');  // ENUM('hijri', 'coptic'), nullable with specified collation
            $table->timestamps();  // Adds 'created_at' and 'updated_at' columns
            $table->softDeletes();
            $table->foreign('day_id')->references('id')->on('days')->onDelete('cascade');
            $table->foreign('week_id')->references('id')->on('weeks')->onDelete('cascade');
            $table->foreign('semester_id')->references('id')->on('semesters')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('semester_week_days');
    }
}
