<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('violation_punishments', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('violation_title_id');
            $table->unsignedBigInteger('violation_punishment_id');
            $table->foreign('violation_title_id')->references('id')->on('violation_titles')->onDelete('cascade');
            $table->foreign('violation_punishment_id')->references('id')->on('namazeg')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('violation_punishments');
    }
};
