<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('sliders', function (Blueprint $table) {
            $table->id();
            $table->text('text')->nullable();
            $table->string('image', 150)->nullable();
            $table->string('start_date', 150)->nullable();
            $table->string('end_date', 150)->nullable();
            $table->enum('start_date_type', ['coptic', 'hijri']);
            $table->enum('end_date_type', ['coptic', 'hijri']);
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('sliders');
    }
};
