<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->string('title',150);
            $table->text('body')->nullable();
            $table->enum('receptor',['all_cities', 'specific_cities','specific_receptors']);
            $table->boolean('scheduled')->default(true);
            $table->string('date',150)->nullable();
            $table->enum('date_type',['coptic','hijri']);
            $table->softDeletes();
            $table->timestamps();
            
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
