<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSchoolEmployeesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('school_employees', function (Blueprint $table) {
            $table->bigIncrements('id');  // UNSIGNED BIGINT, auto-incrementing primary key
            $table->enum('type', ['teacher', 'adminstrative'])->default('teacher')->collation('utf8mb4_unicode_ci');  // ENUM('yes','no'), defaults to 'no' with specified collation
            $table->string('name', 150)->charset('utf8mb3')->collation('utf8mb3_general_ci');  // VARCHAR(150), NOT NULL with specified charset and collation
            $table->string('ssn', 20)->nullable()->charset('utf8mb4')->collation('utf8mb4_general_ci')->unique();  // VARCHAR(20), nullable with specified charset and collation
            $table->string('phone', 25)->nullable()->charset('utf8mb4')->collation('utf8mb4_general_ci')->unique();  // VARCHAR(25), nullable with specified charset and collation
            $table->string('email', 150)->nullable()->charset('utf8mb4')->collation('utf8mb4_general_ci')->unique();  // VARCHAR(150), nullable with specified charset and collation
            $table->unsignedBigInteger('current_work_id')->nullable();  // UNSIGNED BIGINT, nullable
            $table->unsignedBigInteger('specialization_id')->nullable();  // UNSIGNED BIGINT, nullable
            $table->unsignedBigInteger('school_id')->nullable();  // UNSIGNED BIGINT, nullable
            $table->string('current_school_year', 50)->nullable()->collation('utf8mb4_unicode_ci');  // VARCHAR(50), nullable with specified collation
            $table->enum('have_account', ['yes', 'no'])->default('no')->collation('utf8mb4_unicode_ci');  // ENUM('yes','no'), defaults to 'no' with specified collation
            $table->timestamp('created_at')->useCurrent();  // TIMESTAMP, NOT NULL with current timestamp as default
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate();  // TIMESTAMP, NOT NULL with current timestamp as default and on update
            $table->timestamp('deleted_at')->nullable();  // TIMESTAMP, nullable for soft deletes
           
            $table->foreign('current_work_id')->references('id')->on('current_works')->onDelete('cascade');
            $table->foreign('specialization_id')->references('id')->on('specializations')->onDelete('cascade');
            $table->foreign('school_id')->references('id')->on('schools')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('school_employees');
    }
}

