<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateClassNamesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('class_names', function (Blueprint $table) {
            $table->id();  // This will create an auto-incrementing primary key column named 'id'
            $table->string('name', 150)->nullable();  // Creates a VARCHAR(150) column named 'name' that is nullable
            $table->string('category', 150)->nullable();  // Creates a VARCHAR(150) column named 'category' that is nullable
            $table->unsignedBigInteger('school_grade_id')->nullable();  // Creates a BIGINT column named 'school_grade_id' that is nullable
            $table->timestamps();  // This will create 'created_at' and 'updated_at' columns
            $table->softDeletes();
            $table->foreign('school_grade_id')->references('id')->on('school_grades')->onDelete('cascade');

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('class_names');
    }
}
