<?php

namespace Database\Factories\ManagerDashboard\OfficialSpeeches;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\MangerDashboard\Letter>
 */
class LetterFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'type' => $this->faker->randomElement(['official', 'warning']),
            'date_type' => $this->faker->randomElement(['hijri', 'coptic']),
            'date' => $this->faker->date(),
            'title' => $this->faker->sentence(),
            'letter_for' => $this->faker->word(),
            'details' => $this->faker->paragraph(),
        ];
    }
}
