<?php

namespace Database\Factories\AdminDashboard\School;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\Subject;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Teacher>
 */
class TeacherFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->name,
            'school_id'=>School::inRandomOrder()->first()->id,
            'ssn'=> $this->faker->randomNumber,
            'phone'=>$this->faker->phoneNumber,
            'email'=>$this->faker->email(),
        //    'current_work'=> $this->faker->randomElement(['teacher','administrative']),
         //   'subject_id' => Subject::inRandomOrder()->first()->id,
            'current_school_year' => now()->year,
        ];
    }
}
