<?php

namespace App\Models\ManagerDashboard\TeamAndCommitteeMeetings;

use App\Models\AdminDashboard\School\School;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\SoftDeletes;

class Meeting extends Model
{
    use SoftDeletes,CascadeSoftDeletes;
    protected $table='meetings';
    protected $guarded = [];
    protected $cascadeDeletes = ['meetingScheduals','meetingRecommendations'];

    protected function meetingType(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => trans('api.'. $value),
        );
    }

    protected function dateType(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => trans('api.'. $value),
        );
    }

    protected function meetingStatus(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => trans('api.'. $value),
        );
    }

    protected function createdAt(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => \Carbon\Carbon::parse($value)->format('m/d/Y'),
        );
    }

    public function meetingScheduals() {
        return $this->hasMany(MeetingSchedual::class,'meeting_id');
    }

    public function meetingRecommendations() {
        return $this->hasMany(MeetingRecommendation::class,'meeting_id');
    }

   

}
