<?php

namespace App\Models\ManagerDashboard\ClassRoomVisits;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ClassVisitCard extends Model
{
    use HasFactory;
    protected $guarded = [];

    public function ClassRoomVisit()
    {
        return $this->belongsTo(ClassRoomVisitSession::class,'classVisit_id');    
    }

        // Define the relationship with VisitMethod
    public function visitMethods()
    {
        return $this->belongsToMany(VisitMethod::class, 'visit_method_class_visit', 'class_visit_rate_id', 'visit_method_id');
    }

    // Accessor to convert visit_method_ids to an array
    public function getVisitMethodIdsAttribute($value)
    {
        return explode(',', $value);
    }
}
