<?php

namespace App\Models\ManagerDashboard\Circulars;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TeacherGeneralCircular extends Model
{
    use SoftDeletes,CascadeSoftDeletes;
    protected $table='teacher_general_circulars';
    protected $guarded = [];
    protected $cascadeDeletes = ['circularTeachers'];

    protected function createdAt(): Attribute
    {
        return Attribute::make(
            get: fn (string $value) => \Carbon\Carbon::parse($value)->format('m/d/Y'),
        );
    }

    public function circularTeachers()
    {
        return $this->hasMany(TeacherGeneralCircularTeacher::class, 'teacher_general_circular_id');
    }

    public function school()
    {
        return $this->belongsTo(School::class, 'school_id');
    }

    public function teachers()
    {
        return $this->hasManyThrough(
            SchoolEmployee::class,
            TeacherGeneralCircularTeacher::class,
            'teacher_general_circular_id', // Foreign key on CirclersTeachers table...
            'id', // Foreign key on Teachers table...
            'id', // Local key on internal circulars table...
            'school_employee_id' // Local key on internal Circular Teachers table...
        );
    }
}
