<?php

namespace App\Models\ManagerDashboard\Circulars;

use App\Models\AdminDashboard\School\School;
use App\Models\AdminDashboard\School\SchoolEmployee;
use App\Traits\CascadeSoftDeletes;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InternalCircular extends Model
{
    use SoftDeletes,CascadeSoftDeletes;
    protected $table='internal_circulars';
    protected $guarded = [];
    protected $cascadeDeletes = ['circularTeachers'];

    public function circularTeachers()
    {
        return $this->hasMany(InternalCircularTeacher::class, 'internal_circular_id');
    }

    public function school()
    {
        return $this->belongsTo(School::class, 'school_id');
    }

    public function teachers()
    {
        return $this->hasManyThrough(
            SchoolEmployee::class,
            InternalCircularTeacher::class,
            'internal_circular_id', // Foreign key on CirclersTeachers table...
            'id', // Foreign key on SchoolEmployee table...
            'id', // Local key on internal circulars table...
            'school_employee_id' // Local key on internal Circular Teachers table...
        );
    }
}
