<?php

namespace App\Models\ManagerDashboard\Assignments;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class GeneralAssignment extends Model
{
    use HasFactory; use SoftDeletes;

    protected $guarded = [];

 
    public function generalAssignmentEmployees()
    {
        return $this->hasMany(GeneralAssignmentEmployee::class, 'general_assignment_id');
    }
    
    public function duration()
    {
        return $this->belongsTo(DurationAssignment::class,'duration_id');
    }
    
}
