<?php

namespace App\Models\ManagerDashboard\Assignments;

use App\Models\AdminDashboard\School\SchoolEmployee;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AssignmentEmployee extends Model
{
    use HasFactory; use SoftDeletes;

    protected $table = 'assignment_employees';

    protected $guarded=[];
    public function assignment()
    {
        return $this->belongsTo(Assignment::class, 'assignment_id');
    }

    public function employee()
    {
        return $this->belongsTo(SchoolEmployee::class, 'employee_id'); // Assuming 'SchoolEmployee' is the employee model
    }
    
}
